/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Map;
import java.util.SortedMap;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.rfc3779.AddressFamily;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionParser;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateObject;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.ResourceValidatorFactory;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;
import org.apache.commons.lang3.Validate;

public class X509ResourceCertificate
extends X509GenericCertificate
implements X509CertificateObject {
    private static final long serialVersionUID = 2L;
    private final EnumSet<IpResourceType> inheritedResourceTypes;
    private final IpResourceSet resources;
    private Boolean revoked;

    protected X509ResourceCertificate(X509Certificate certificate) {
        super(certificate);
        byte[] asnExtension;
        ResourceExtensionParser parser = new ResourceExtensionParser();
        this.inheritedResourceTypes = EnumSet.noneOf(IpResourceType.class);
        this.resources = new IpResourceSet();
        byte[] ipAddressBlocksExtension = this.getCertificate().getExtensionValue(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId());
        if (ipAddressBlocksExtension != null) {
            SortedMap<AddressFamily, IpResourceSet> ipResources = parser.parseIpAddressBlocks(ipAddressBlocksExtension);
            for (Map.Entry<AddressFamily, IpResourceSet> resourcesByType : ipResources.entrySet()) {
                if (resourcesByType.getValue() == null) {
                    this.inheritedResourceTypes.add(resourcesByType.getKey().toIpResourceType());
                    continue;
                }
                this.resources.addAll(resourcesByType.getValue());
            }
        }
        if ((asnExtension = this.getCertificate().getExtensionValue(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId())) != null) {
            IpResourceSet asResources = parser.parseAsIdentifiers(asnExtension);
            if (asResources == null) {
                this.inheritedResourceTypes.add(IpResourceType.ASN);
            } else {
                this.resources.addAll(asResources);
            }
        }
        Validate.isTrue((!this.inheritedResourceTypes.isEmpty() || !this.resources.isEmpty() ? 1 : 0) != 0, (String)"empty resource set", (Object[])new Object[0]);
    }

    public IpResourceSet getResources() {
        return new IpResourceSet(this.resources);
    }

    public EnumSet<IpResourceType> getInheritedResourceTypes() {
        return this.inheritedResourceTypes;
    }

    public boolean isResourceTypesInherited(EnumSet<IpResourceType> resourceTypes) {
        return this.inheritedResourceTypes.containsAll(resourceTypes);
    }

    public boolean isResourceSetInherited() {
        return !this.inheritedResourceTypes.isEmpty();
    }

    @Override
    public URI getCrlUri() {
        return this.findFirstRsyncCrlDistributionPoint();
    }

    @Override
    public URI getParentCertificateUri() {
        return this.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS);
    }

    public void validate(String location, X509ResourceCertificateValidator validator) {
        X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
        parser.parse(ValidationResult.withLocation(location), this.getEncoded());
        if (parser.getValidationResult().hasFailures()) {
            return;
        }
        validator.validate(location, this);
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        X509Crl crl = null;
        if (!this.isRoot()) {
            ValidationLocation savedCurrentLocation = result.getCurrentLocation();
            result.setLocation(new ValidationLocation(this.getCrlUri()));
            crl = crlLocator.getCrl(this.getCrlUri(), context, result);
            result.setLocation(savedCurrentLocation);
            if (crl == null) {
                result.rejectIfFalse(false, "objects.crl.valid", this.getCrlUri().toString());
                return;
            }
        }
        X509ResourceCertificateValidator validator = ResourceValidatorFactory.getX509ResourceCertificateValidator(context, options, result, crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, X509Crl crl, URI crlUri, ValidationOptions options, ValidationResult result) {
        if (!this.isRoot() && crl == null) {
            result.rejectIfFalse(false, "objects.crl.valid", crlUri.toString());
            return;
        }
        X509ResourceCertificateValidator validator = ResourceValidatorFactory.getX509ResourceCertificateValidator(context, options, result, crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public boolean isPastValidityTime() {
        return this.getValidityPeriod().isExpiredNow();
    }

    @Override
    public boolean isRevoked() {
        if (this.revoked == null) {
            throw new IllegalStateException("isRevoked() could only be called after validate()");
        }
        return this.revoked;
    }

    public IpResourceSet deriveResources(IpResourceSet parentResources) {
        IpResourceSet result = new IpResourceSet(this.resources);
        if (this.inheritedResourceTypes.isEmpty()) {
            return result;
        }
        for (IpResource ipResource : parentResources) {
            if (!this.inheritedResourceTypes.contains(ipResource.getType())) continue;
            result.add(ipResource);
        }
        return result;
    }

    public boolean containsResources(IpResourceSet that) {
        return this.resources.contains(that);
    }
}

