/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.rfc8209.RouterExtensionEncoder;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilderException;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class X509CertificateBuilderHelper {
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String DEFAULT_SIGNATURE_PROVIDER = "SunRsaSign";
    private static final BigInteger MAX_20_OCTETS = BigInteger.ONE.shiftLeft(160).subtract(BigInteger.ONE);
    private String signatureProvider = "SunRsaSign";
    private String signatureAlgorithm = "SHA256withRSA";
    private BigInteger serial;
    private X500Principal subjectDN;
    private X500Principal issuerDN;
    private ValidityPeriod validityPeriod;
    private IpResourceSet resources;
    private PublicKey publicKey;
    private KeyPair signingKeyPair;
    private int keyUsage;
    private boolean ca;
    private boolean router = false;
    private boolean addAuthorityKeyIdentifier = true;
    private URI[] crlDistributionPoints;
    private AccessDescription[] authorityInformationAccess;
    private AccessDescription[] subjectInformationAccess;
    private PolicyInformation[] policies;
    private EnumSet<IpResourceType> inheritedResourceTypes = EnumSet.noneOf(IpResourceType.class);

    public X509CertificateBuilderHelper withSignatureProvider(String signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public X509CertificateBuilderHelper withSerial(BigInteger serial) {
        this.serial = serial;
        return this;
    }

    public X509CertificateBuilderHelper withSubjectDN(X500Principal subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public X509CertificateBuilderHelper withIssuerDN(X500Principal issuerDN) {
        this.issuerDN = issuerDN;
        return this;
    }

    public X509CertificateBuilderHelper withValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public X509CertificateBuilderHelper withResources(IpResourceSet resources) {
        this.resources = resources;
        return this;
    }

    public X509CertificateBuilderHelper withPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public X509CertificateBuilderHelper withSigningKeyPair(KeyPair signingKey) {
        this.signingKeyPair = signingKey;
        return this;
    }

    public X509CertificateBuilderHelper withSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public X509CertificateBuilderHelper withKeyUsage(int keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    public X509CertificateBuilderHelper withCa(boolean ca) {
        this.ca = ca;
        if (ca) {
            this.router = false;
        }
        return this;
    }

    public X509CertificateBuilderHelper withRouter(boolean router) {
        this.router = router;
        if (router) {
            this.ca = false;
        }
        return this;
    }

    public X509CertificateBuilderHelper withAuthorityKeyIdentifier(boolean add) {
        this.addAuthorityKeyIdentifier = add;
        return this;
    }

    public X509CertificateBuilderHelper withCrlDistributionPoints(URI ... uris) {
        this.crlDistributionPoints = uris;
        return this;
    }

    public X509CertificateBuilderHelper withAuthorityInformationAccess(X509CertificateInformationAccessDescriptor ... descriptors) {
        this.authorityInformationAccess = X509CertificateInformationAccessDescriptor.convertAccessDescriptors(descriptors);
        return this;
    }

    public X509CertificateBuilderHelper withSubjectInformationAccess(X509CertificateInformationAccessDescriptor ... descriptors) {
        this.subjectInformationAccess = X509CertificateInformationAccessDescriptor.convertAccessDescriptors(descriptors);
        return this;
    }

    public X509CertificateBuilderHelper withPolicies(PolicyInformation ... policies) {
        if (this.policies != null) {
            throw new IllegalStateException("Certificate policies can not be overridden once set.");
        }
        this.policies = policies;
        return this;
    }

    public X509CertificateBuilderHelper withInheritedResourceTypes(EnumSet<IpResourceType> resourceTypes) {
        this.inheritedResourceTypes = EnumSet.copyOf(resourceTypes);
        return this;
    }

    public X509Certificate generateCertificate() {
        X509v3CertificateBuilder certificateGenerator = this.createCertificateGenerator();
        try {
            ContentSigner signer = new JcaContentSignerBuilder(this.signatureAlgorithm).setProvider(this.signatureProvider).build(this.signingKeyPair.getPrivate());
            return new JcaX509CertificateConverter().getCertificate(certificateGenerator.build(signer));
        }
        catch (IllegalStateException | CertificateException | OperatorCreationException e) {
            throw new X509ResourceCertificateBuilderException(e);
        }
    }

    protected X509v3CertificateBuilder createCertificateGenerator() {
        try {
            X509v3CertificateBuilder generator = this.createX509V3CertificateGenerator();
            this.addSubjectKeyIdentifier(generator);
            if (this.addAuthorityKeyIdentifier) {
                this.addAuthorityKeyIdentifier(generator);
            }
            if (this.ca) {
                this.addCaBit(generator);
            }
            if (this.router) {
                this.addBgpExtension(generator);
            }
            if (this.keyUsage != 0) {
                this.addKeyUsage(generator);
            }
            if (this.authorityInformationAccess != null) {
                this.addAIA(generator);
            }
            if (this.subjectInformationAccess != null) {
                this.addSIA(generator);
            }
            if (this.crlDistributionPoints != null) {
                Validate.noNullElements((Object[])this.crlDistributionPoints);
                this.addCrlDistributionPoints(generator);
            }
            if (this.policies != null && this.policies.length > 0) {
                this.addPolicies(generator);
            }
            if (this.resources != null) {
                this.validateResource(this.resources);
                this.addResourceExtensions(generator);
            }
            return generator;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | CertIOException e) {
            throw new X509ResourceCertificateBuilderException(e);
        }
    }

    protected void validateResource(IpResourceSet resources) {
        boolean atLeastOneResourceTypeUsed = EnumSet.allOf(IpResourceType.class).stream().anyMatch(resourceType -> resources.containsType(resourceType) || this.inheritedResourceTypes.contains(resourceType));
        if (!atLeastOneResourceTypeUsed) {
            throw new IllegalArgumentException("Resources set " + resources + " must contain at least one IP address or ASN");
        }
    }

    private void addBgpExtension(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.getInstance((Object)RouterExtensionEncoder.OID_KP_BGPSEC_ROUTER)));
    }

    private X509v3CertificateBuilder createX509V3CertificateGenerator() {
        this.validateCertificateFields();
        return new X509v3CertificateBuilder(BouncyCastleUtil.principalToName(this.issuerDN), this.serial, new Date(this.validityPeriod.getNotValidBefore().getMillis()), new Date(this.validityPeriod.getNotValidAfter().getMillis()), BouncyCastleUtil.principalToName(this.subjectDN), BouncyCastleUtil.createSubjectPublicKeyInfo(this.publicKey));
    }

    private void validateCertificateFields() {
        Validate.notNull((Object)this.issuerDN, (String)"no issuerDN", (Object[])new Object[0]);
        Validate.notNull((Object)this.subjectDN, (String)"no subjectDN", (Object[])new Object[0]);
        Validate.notNull((Object)this.serial, (String)"no serial", (Object[])new Object[0]);
        Validate.isTrue((this.serial.compareTo(BigInteger.ZERO) > 0 && this.serial.compareTo(MAX_20_OCTETS) <= 0 ? 1 : 0) != 0, (String)"serial number not in (0..MAX)", (Object[])new Object[0]);
        Validate.notNull((Object)this.publicKey, (String)"no publicKey", (Object[])new Object[0]);
        Validate.notNull((Object)this.signingKeyPair, (String)"no signingKeyPair", (Object[])new Object[0]);
        Validate.notNull((Object)this.validityPeriod, (String)"no validityPeriod", (Object[])new Object[0]);
        Validate.isTrue((boolean)"RSA".equals(this.publicKey.getAlgorithm()), (String)"publicKey algorithm is not RSA", (Object[])new Object[0]);
        if (!this.ca) {
            Validate.isTrue(((this.keyUsage & 4) == 0 ? 1 : 0) != 0, (String)"keyCertSign only allowed for ca", (Object[])new Object[0]);
        }
    }

    private void addSubjectKeyIdentifier(X509v3CertificateBuilder generator) throws InvalidKeyException, CertIOException, NoSuchAlgorithmException {
        generator.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(this.publicKey));
    }

    private void addAuthorityKeyIdentifier(X509v3CertificateBuilder generator) throws InvalidKeyException, CertIOException {
        generator.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)BouncyCastleUtil.createAuthorityKeyIdentifier(this.signingKeyPair.getPublic()));
    }

    private void addCaBit(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(this.ca));
    }

    private void addKeyUsage(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(this.keyUsage));
    }

    private void addAIA(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)AuthorityInformationAccess.getInstance((Object)new DERSequence((ASN1Encodable[])this.authorityInformationAccess)));
    }

    private void addSIA(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.subjectInfoAccess, false, (ASN1Encodable)AuthorityInformationAccess.getInstance((Object)new DERSequence((ASN1Encodable[])this.subjectInformationAccess)));
    }

    private void addCrlDistributionPoints(X509v3CertificateBuilder generator) throws CertIOException {
        CRLDistPoint crldp = this.convertToCrlDistributionPoint(this.crlDistributionPoints);
        generator.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)crldp);
    }

    private void addPolicies(X509v3CertificateBuilder generator) throws CertIOException {
        generator.addExtension(Extension.certificatePolicies, true, (ASN1Encodable)new DERSequence((ASN1Encodable[])this.policies));
    }

    private void addResourceExtensions(X509v3CertificateBuilder generator) throws CertIOException {
        ASN1Object encodedASNs;
        ResourceExtensionEncoder encoder = new ResourceExtensionEncoder();
        for (IpResourceType inherited : this.inheritedResourceTypes) {
            if (!this.resources.containsType(inherited)) continue;
            throw new IllegalArgumentException("resource set '" + this.resources + "' contains resources of inherited type " + inherited);
        }
        ASN1Object encodedIPAddressBlocks = encoder.encodeIpAddressBlocks(this.inheritedResourceTypes.contains(IpResourceType.IPv4), this.inheritedResourceTypes.contains(IpResourceType.IPv6), this.resources);
        if (encodedIPAddressBlocks != null) {
            generator.addExtension(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS, true, (ASN1Encodable)encodedIPAddressBlocks);
        }
        if ((encodedASNs = encoder.encodeAsIdentifiers(this.inheritedResourceTypes.contains(IpResourceType.ASN), this.resources)) != null) {
            generator.addExtension(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS, true, (ASN1Encodable)encodedASNs);
        }
    }

    private CRLDistPoint convertToCrlDistributionPoint(URI[] uris) {
        GeneralName[] seq = new GeneralName[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            seq[i] = new GeneralName(6, uris[i].toString());
        }
        GeneralNames names = new GeneralNames(seq);
        DistributionPointName distributionPoint = new DistributionPointName(names);
        DistributionPoint[] dps = new DistributionPoint[]{new DistributionPoint(distributionPoint, null, null)};
        return new CRLDistPoint(dps);
    }
}

