/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.util.encoders.Hex;

public final class KeyPairUtil {
    private KeyPairUtil() {
    }

    public static String getEncodedKeyIdentifier(PublicKey key) {
        String encoded = KeyPairUtil.base64UrlEncode(KeyPairUtil.getKeyIdentifier(key));
        return StringUtils.stripEnd((String)encoded, (String)"=");
    }

    public static String getAsciiHexEncodedPublicKeyHash(PublicKey publicKey) {
        return KeyPairUtil.hexEncodeHashData(KeyPairUtil.getKeyIdentifier(publicKey));
    }

    static String hexEncodeHashData(byte[] keyHashData) {
        return Hex.toHexString((byte[])keyHashData);
    }

    public static byte[] getKeyIdentifier(PublicKey key) {
        try {
            return new JcaX509ExtensionUtils().createSubjectKeyIdentifier(key).getKeyIdentifier();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Could not get SubjectKeyIdentifierStructure from key", e);
        }
    }

    public static String base64UrlEncode(byte[] data) {
        return Base64.getUrlEncoder().encodeToString(data);
    }
}

