/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.ta.serializers;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateObject;
import net.ripe.rpki.commons.ta.domain.response.SigningResponse;
import net.ripe.rpki.commons.ta.domain.response.TrustAnchorResponse;
import net.ripe.rpki.commons.ta.serializers.TrustAnchorResponseSerializer;
import net.ripe.rpki.commons.ta.serializers.Utils;
import net.ripe.rpki.commons.util.XML;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TrustAnchorResponseSerializerTest {
    private static final String TA_RESPONSE_PATH = "src/test/resources/ta/ta-response.xml";
    private Document document;
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private TrustAnchorResponse response;

    @Before
    public void loadState() throws IOException, SAXException, ParserConfigurationException {
        String responseXML = Files.asCharSource((File)new File(TA_RESPONSE_PATH), (Charset)Charsets.UTF_8).read();
        TrustAnchorResponseSerializer trustAnchorResponseSerializer = new TrustAnchorResponseSerializer();
        this.response = trustAnchorResponseSerializer.deserialize(responseXML);
        DocumentBuilder builder = XML.newNamespaceAwareDocumentBuilder();
        this.document = builder.parse(new File(TA_RESPONSE_PATH));
    }

    @Test
    public void shouldMatchSimpleFields() throws XPathExpressionException {
        Assert.assertEquals((Object)Long.valueOf(this.xpath.evaluate("/TrustAnchorResponse/requestCreationTimestamp", this.document)), (Object)this.response.getRequestCreationTimestamp());
    }

    @Test
    public void shouldMatchTAResponseField() throws XPathExpressionException, URISyntaxException {
        List taResponses = this.response.getTaResponses();
        XPathExpression query = this.xpath.compile("/TrustAnchorResponse/taResponses/SigningResponse");
        NodeList nodeList = (NodeList)query.evaluate(this.document, XPathConstants.NODESET);
        Assert.assertEquals((long)nodeList.getLength(), (long)taResponses.size());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SigningResponse sr = (SigningResponse)taResponses.get(i);
            Node cur = nodeList.item(i);
            Assert.assertEquals((Object)UUID.fromString(this.xpath.evaluate("requestId", cur)), (Object)sr.getRequestId());
            Assert.assertEquals((Object)this.xpath.evaluate("resourceClassName", cur), (Object)sr.getResourceClassName());
            Assert.assertEquals((Object)new URI(this.xpath.evaluate("publicationUri", cur)), (Object)sr.getPublicationUri());
            Assert.assertEquals((Object)Utils.cleanupBase64(this.xpath.evaluate("certificate/encoded", cur)), (Object)Base64.toBase64String((byte[])sr.getCertificate().getEncoded()));
        }
    }

    @Test
    public void shouldMatchPublishedObjects() throws XPathExpressionException, URISyntaxException {
        NodeList entries = (NodeList)this.xpath.evaluate("/TrustAnchorResponse/publishedObjects/entry", this.document, XPathConstants.NODESET);
        Assert.assertEquals((long)entries.getLength(), (long)this.response.getPublishedObjects().size());
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            URI entryURI = new URI(this.xpath.evaluate("uri", entry));
            CertificateRepositoryObject publishedObject = (CertificateRepositoryObject)this.response.getPublishedObjects().get(entryURI);
            String encodedCertificate = this.xpath.evaluate("X509ResourceCertificate/encoded", entry);
            if (StringUtils.isEmpty((CharSequence)encodedCertificate)) {
                Assert.assertFalse((boolean)(publishedObject instanceof X509CertificateObject));
            } else {
                Assert.assertTrue((boolean)(publishedObject instanceof X509CertificateObject));
                X509CertificateObject xco = (X509CertificateObject)publishedObject;
                Assert.assertEquals((Object)Utils.cleanupBase64(encodedCertificate), (Object)Base64.toBase64String((byte[])xco.getEncoded()));
            }
            String encodedCrl = this.xpath.evaluate("CRL/encoded", entry);
            if (StringUtils.isEmpty((CharSequence)encodedCrl)) {
                Assert.assertFalse((boolean)(publishedObject instanceof X509Crl));
            } else {
                Assert.assertTrue((boolean)(publishedObject instanceof X509Crl));
                X509Crl crl = (X509Crl)publishedObject;
                Assert.assertEquals((Object)Utils.cleanupBase64(encodedCrl), (Object)Base64.toBase64String((byte[])crl.getEncoded()));
            }
            String encodedManifest = this.xpath.evaluate("Manifest/encoded", entry);
            if (StringUtils.isEmpty((CharSequence)encodedManifest)) {
                Assert.assertFalse((boolean)(publishedObject instanceof ManifestCms));
                continue;
            }
            Assert.assertTrue((boolean)(publishedObject instanceof ManifestCms));
            ManifestCms mfs = (ManifestCms)publishedObject;
            Assert.assertEquals((Object)Utils.cleanupBase64(encodedManifest), (Object)Base64.toBase64String((byte[])mfs.getEncoded()));
        }
    }

    @Test
    public void shouldSerialiseAndDeserialise() throws IOException {
        String responseXML = Files.asCharSource((File)new File(TA_RESPONSE_PATH), (Charset)Charsets.UTF_8).read();
        TrustAnchorResponseSerializer trustAnchorResponseSerializer = new TrustAnchorResponseSerializer();
        TrustAnchorResponse response = trustAnchorResponseSerializer.deserialize(responseXML);
        String responseXML2 = trustAnchorResponseSerializer.serialize(response);
        TrustAnchorResponse response1 = trustAnchorResponseSerializer.deserialize(responseXML2);
        Assert.assertEquals((Object)response1, (Object)response);
    }
}

