/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.list.response;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElementBuilder;
import net.ripe.rpki.commons.provisioning.payload.common.GenericClassElementBuilder;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponseClassElement;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponsePayloadSerializer;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ResourceClassListResponsePayloadSerializerTest {
    private static final XmlSerializer<ResourceClassListResponsePayload> SERIALIZER = new ResourceClassListResponsePayloadSerializer();
    private static DateTime validityNotAfter = new DateTime(2011, 1, 1, 23, 58, 23, 0).withZone(DateTimeZone.UTC);
    public static ResourceClassListResponsePayload TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD = ResourceClassListResponsePayloadSerializerTest.createResourceClassListResponsePayload();

    public static ResourceClassListResponsePayload createResourceClassListResponsePayload() {
        ResourceClassListResponsePayloadBuilder builder = new ResourceClassListResponsePayloadBuilder();
        CertificateElement certificateElement = new CertificateElementBuilder().withIpResources(IpResourceSet.parse((String)"123,10.0.0.0/8,2001:0DB8::/48")).withCertificatePublishedLocations(Arrays.asList(URI.create("rsync://jaja/jja"))).withCertificate(ProvisioningObjectMother.X509_CA).build();
        GenericClassElementBuilder classElementBuilder = new GenericClassElementBuilder().withClassName("a classname").withCertificateAuthorityUri(Arrays.asList(URI.create("rsync://localhost/some/where"), URI.create("http://some/other"))).withIpResourceSet(IpResourceSet.parse((String)"1234,456,192.168.0.0/24,2001:db8::/48,2001:0DB8:002::-2001:0DB8:005::")).withValidityNotAfter(validityNotAfter).withSiaHeadUri("rsync://some/where").withCertificateElements(Arrays.asList(certificateElement)).withIssuer(ProvisioningObjectMother.X509_CA);
        builder.addClassElement(classElementBuilder.buildResourceClassListResponseClassElement());
        classElementBuilder.withClassName("class2");
        classElementBuilder.withCertificateElements(Arrays.asList(certificateElement, certificateElement));
        builder.addClassElement(classElementBuilder.buildResourceClassListResponseClassElement());
        return builder.build();
    }

    @Test
    public void shouldBuildValidListResponsePayload() throws URISyntaxException {
        Assert.assertEquals((Object)"sender", (Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD.getRecipient());
        ResourceClassListResponseClassElement firstClassElement = (ResourceClassListResponseClassElement)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD.getClassElements().get(0);
        Assert.assertEquals((Object)URI.create("http://some/other"), firstClassElement.getCertificateAuthorityUri().get(1));
        Assert.assertEquals((Object)"a classname", (Object)firstClassElement.getClassName());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"192.168.0.0/24"), (Object)firstClassElement.getResourceSetIpv4());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"2001:db8::/48,2001:0DB8:002::-2001:0DB8:005::"), (Object)firstClassElement.getResourceSetIpv6());
        Assert.assertEquals((Object)validityNotAfter, (Object)firstClassElement.getValidityNotAfter());
        Assert.assertEquals((Object)"rsync://some/where", (Object)firstClassElement.getSiaHeadUri());
        Assert.assertArrayEquals((byte[])ProvisioningObjectMother.X509_CA.getEncoded(), (byte[])firstClassElement.getIssuer().getEncoded());
        List certificateElements = firstClassElement.getCertificateElements();
        Assert.assertEquals((long)1L, (long)certificateElements.size());
        CertificateElement certificateElement = (CertificateElement)certificateElements.get(0);
        Assert.assertEquals((Object)URI.create("rsync://jaja/jja"), certificateElement.getIssuerCertificatePublicationUris().get(0));
        Assert.assertEquals((Object)IpResourceSet.parse((String)"123"), (Object)certificateElement.getAllocatedAsn());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"10.0.0.0/8"), (Object)certificateElement.getAllocatedIpv4());
        Assert.assertEquals((Object)IpResourceSet.parse((String)"2001:0DB8::/48"), (Object)certificateElement.getAllocatedIpv6());
        Assert.assertArrayEquals((byte[])ProvisioningObjectMother.X509_CA.getEncoded(), (byte[])certificateElement.getCertificate().getEncoded());
    }

    @Test
    public void shouldCreatePayloadXmlConformDraft() {
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD);
        Pattern expectedXmlRegex = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message\\s+xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"\\s+recipient=\"recipient\"\\s+sender=\"sender\"\\s+type=\"list_response\"\\s+version=\"1\">\n   <class\\s+cert_url=\"rsync://localhost/some/where,http://some/other\"\\s+class_name=\"a classname\"\\s+resource_set_as=\"456,1234\"\\s+resource_set_ipv4=\"192.168.0.0/24\"\\s+resource_set_ipv6=\"2001:db8::/48,2001:db8:2::-2001:db8:5::\"\\s+resource_set_notafter=\"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z\"\\s+suggested_sia_head=\"rsync://some/where\">\n      <certificate\\s+cert_url=\"rsync://jaja/jja\"\\s+req_resource_set_as=\"123\"\\s+req_resource_set_ipv4=\"10.0.0.0/8\"\\s+req_resource_set_ipv6=\"2001:db8::/48\">[^<]*</certificate>\n      <issuer>[^<]*</issuer>\n   </class>\n   <class\\s+cert_url=\"rsync://localhost/some/where,http://some/other\"\\s+class_name=\"class2\"\\s+resource_set_as=\"456,1234\"\\s+resource_set_ipv4=\"192.168.0.0/24\"\\s+resource_set_ipv6=\"2001:db8::/48,2001:db8:2::-2001:db8:5::\"\\s+resource_set_notafter=\"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z\"\\s+suggested_sia_head=\"rsync://some/where\">\n      <certificate\\s+cert_url=\"rsync://jaja/jja\"\\s+req_resource_set_as=\"123\"\\s+req_resource_set_ipv4=\"10.0.0.0/8\"\\s+req_resource_set_ipv6=\"2001:db8::/48\">[^<]*</certificate>\n      <certificate\\s+cert_url=\"rsync://jaja/jja\"\\s+req_resource_set_as=\"123\"\\s+req_resource_set_ipv4=\"10.0.0.0/8\"\\s+req_resource_set_ipv6=\"2001:db8::/48\">[^<]*</certificate>\n      <issuer>[^<]*</issuer>\n   </class>\n</message>\n", 32);
        Assert.assertTrue((String)("actual: " + actualXml), (boolean)expectedXmlRegex.matcher(actualXml).matches());
    }

    @Test
    public void shouldDeserializeXml() {
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD);
        ResourceClassListResponsePayload deserialized = (ResourceClassListResponsePayload)SERIALIZER.deserialize(actualXml);
        Assert.assertEquals((Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD, (Object)deserialized);
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

