/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BBNCertificateConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Ignore(value="Early ripe ncc ta certificates have crldp set")
    @Test
    public void shouldRejectSelfSignedCertificateWithCRLDP() throws IOException {
        boolean hasFailure = this.parseCertificate("badRootBadCRLDP.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithReasonFieldNotOmitted() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPReasons.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithCRLDPWithCrlIssuer() throws IOException {
        boolean hasFailure = this.parseCertificate("root/badCertCRLDPCrlIssuer.cer");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldRejectCertificateWithoutKeyUsageBit() throws IOException {
        Assert.assertTrue((boolean)this.parseCertificate("root/badCertNoKeyUsage.cer"));
    }

    @Test
    public void shouldRejectCertificateWithTwoKeyUsageBits() throws IOException {
        Assert.assertTrue((boolean)this.parseCertificate("root/badCert2KeyUsage.cer"));
    }

    @Test
    public void shouldRejectCertificateWithIncorrectKeyUsageBits() throws IOException {
        List<String> testCaseNames = Arrays.asList("KUsageExtra", "KUsageDigitalSig", "KUsageNoCertSign", "KUsageNoCrit", "KUsageNoCRLSign");
        testCaseNames.forEach(testCase -> {
            String fileName = String.format("root/badCert%s.cer", testCase);
            try {
                Assert.assertTrue((String)("Should reject certificate with " + testCase + " from " + fileName), (boolean)this.parseCertificate(fileName));
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)false);
            }
        });
    }

    private boolean certificateHasWarningOrFailure(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new X509ResourceCertificateParser().parse(result, encoded);
        return result.hasFailures() || result.hasWarnings();
    }

    private boolean parseCertificate(String certificate) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, certificate);
        byte[] encoded = Files.toByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new X509ResourceCertificateParser().parse(result, encoded);
        return result.hasFailures();
    }
}

