/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.provisioning.identity.ChildIdentity;
import net.ripe.rpki.commons.provisioning.identity.IdentitySerializer;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChildIdentitySerializer
extends IdentitySerializer<ChildIdentity> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ChildIdentity deserialize(String xml) {
        try (StringReader characterStream = new StringReader(xml);){
            Document doc = this.getDocumentBuilder().parse(new InputSource(characterStream));
            Element root = this.getElement(doc, "child_request").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("child_request element not found"));
            String childHandle = this.getRequiredAttributeValue(root, "child_handle");
            String childBpkiTa = this.getBpkiElementContent(doc, "child_bpki_ta").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("child_bpki_ta element not found"));
            ProvisioningIdentityCertificate provisioningIdentityCertificate = this.getProvisioningIdentityCertificate(childBpkiTa);
            ChildIdentity childIdentity = new ChildIdentity(childHandle, provisioningIdentityCertificate);
            return childIdentity;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IdentitySerializer.IdentitySerializerException("Fail to parse child request", e);
        }
    }

    @Override
    public String serialize(ChildIdentity childIdentity) {
        try {
            Document document = this.getDocumentBuilder().newDocument();
            Element childRequestElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "child_request");
            childRequestElement.setAttribute("child_handle", childIdentity.getHandle());
            childRequestElement.setAttribute("version", Integer.toString(childIdentity.getVersion()));
            Element childBpkiTaElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "child_bpki_ta");
            childBpkiTaElement.setTextContent(childIdentity.getIdentityCertificate().getBase64String());
            childRequestElement.appendChild(childBpkiTaElement);
            document.appendChild(childRequestElement);
            return this.serialize(document);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IdentitySerializer.IdentitySerializerException(e);
        }
    }
}

