/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.issue.response;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.payload.PayloadMessageType;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElementBuilder;
import net.ripe.rpki.commons.provisioning.payload.common.GenericClassElementBuilder;
import net.ripe.rpki.commons.provisioning.payload.issue.response.CertificateIssuanceResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.issue.response.CertificateIssuanceResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.issue.response.CertificateIssuanceResponsePayloadSerializer;
import net.ripe.rpki.commons.xml.XmlSerializer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class CertificateIssuanceResponsePayloadSerializerTest {
    private static final XmlSerializer<CertificateIssuanceResponsePayload> SERIALIZER = new CertificateIssuanceResponsePayloadSerializer();
    private static final DateTime validityNotAfter = new DateTime(2011, 1, 1, 23, 58, 23, 0).withZone(DateTimeZone.UTC);
    public static final CertificateIssuanceResponsePayload TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD = CertificateIssuanceResponsePayloadSerializerTest.createCertificateIssuanceResponsePayload();

    @Before
    public void given() {
        CertificateIssuanceResponsePayloadSerializerTest.createCertificateIssuanceResponsePayload();
    }

    private static CertificateIssuanceResponsePayload createCertificateIssuanceResponsePayload() {
        CertificateElement certificateElement = new CertificateElementBuilder().withIpResources(IpResourceSet.parse((String)"123,10.0.0.0/8,192.168.0.0/16,2001:0DB8::/48")).withCertificatePublishedLocations(Arrays.asList(URI.create("rsync://jaja/jj,a"))).withCertificate(ProvisioningObjectMother.X509_CA).build();
        ArrayList<URI> certUris = new ArrayList<URI>();
        certUris.add(URI.create("rsync://localhost/so,me/where"));
        certUris.add(URI.create("http://some/other"));
        GenericClassElementBuilder classElementBuilder = new GenericClassElementBuilder().withClassName("a classname").withCertificateAuthorityUri(certUris).withIpResourceSet(IpResourceSet.parse((String)"1234,456,192.168.0.0/24,2001:0DB8::/48,2001:0DB8:002::-2001:0DB8:005::")).withValidityNotAfter(validityNotAfter).withSiaHeadUri("rsync://some/where").withCertificateElements(Arrays.asList(certificateElement)).withIssuer(ProvisioningObjectMother.X509_CA);
        CertificateIssuanceResponsePayloadBuilder builder = new CertificateIssuanceResponsePayloadBuilder();
        builder.withClassElement(classElementBuilder.buildCertificateIssuanceResponseClassElement());
        return builder.build();
    }

    @Test
    public void shouldBuildValidCIResponsePayload() throws URISyntaxException {
        Assert.assertEquals((Object)PayloadMessageType.issue_response, (Object)TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD.getType());
    }

    @Test
    public void shouldHavePayloadXmlConformStandard() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD);
        Pattern expectedXmlRegex = Pattern.compile("<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message\\s+xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"\\s+recipient=\"recipient\"\\s+sender=\"sender\"\\s+type=\"issue_response\"\\s+version=\"1\">\n   <class\\s+cert_url=\"rsync://localhost/so%2Cme/where,http://some/other\"\\s+class_name=\"a classname\"\\s+resource_set_as=\"456,1234\"\\s+resource_set_ipv4=\"192.168.0.0/24\"\\s+resource_set_ipv6=\"2001:db8::/48,2001:db8:2::-2001:db8:5::\"\\s+resource_set_notafter=\"\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z\"\\s+suggested_sia_head=\"rsync://some/where\">\n      <certificate\\s+cert_url=\"rsync://jaja/jj%2Ca\"\\s+req_resource_set_as=\"123\"\\s+req_resource_set_ipv4=\"10.0.0.0/8,192.168.0.0/16\"\\s+req_resource_set_ipv6=\"2001:db8::/48\">[^<]*</certificate>\n      <issuer>[^<]*</issuer>\n   </class>\n</message>\n", 32);
        Assert.assertTrue((String)("actual: " + actualXml), (boolean)expectedXmlRegex.matcher(actualXml).matches());
    }

    @Test
    public void shouldDeserializeXml() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD);
        CertificateIssuanceResponsePayload deserialized = (CertificateIssuanceResponsePayload)SERIALIZER.deserialize(actualXml);
        Assert.assertEquals((Object)TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD.toString(), (Object)deserialized.toString().replace("%2C", ","));
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

