/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.util.Arrays;
import net.ripe.rpki.commons.rsync.Command;
import org.junit.Assert;
import org.junit.Test;

public class CommandTest {
    private static final String COMMAND = "whoami";

    @Test
    public void shouldExecuteCommand() {
        Command cmd = new Command(COMMAND);
        Assert.assertTrue((cmd.getExitStatus() == -1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cmd.wasStarted());
        Assert.assertFalse((boolean)cmd.isCompleted());
        Assert.assertNull((Object)cmd.getException());
        Assert.assertNull((Object)cmd.getErrorLines());
        Assert.assertNull((Object)cmd.getErrors());
        Assert.assertNull((Object)cmd.getOutputLines());
        Assert.assertNull((Object)cmd.getOutputs());
        cmd.execute();
        int exitStatus = cmd.getExitStatus();
        Assert.assertTrue((exitStatus == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cmd.wasStarted());
        Assert.assertTrue((boolean)cmd.isCompleted());
        Assert.assertNull((Object)cmd.getException());
        Assert.assertNotNull((Object)cmd.getErrorLines());
        Assert.assertTrue((cmd.getErrorLines().length == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cmd.getErrors());
        Assert.assertTrue((cmd.getErrors().size() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cmd.getOutputLines());
        Assert.assertTrue((cmd.getOutputLines().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cmd.getOutputs());
        Assert.assertTrue((cmd.getOutputs().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFailOnInvalidCommand() {
        Command cmd = new Command("invalid_command", null, "/");
        cmd.execute();
        Assert.assertTrue((cmd.getExitStatus() == -2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cmd.wasStarted());
        Assert.assertTrue((boolean)cmd.isCompleted());
        Assert.assertNotNull((Object)cmd.getException());
        Assert.assertNull((Object)cmd.getErrorLines());
        Assert.assertNull((Object)cmd.getErrors());
        Assert.assertNull((Object)cmd.getOutputLines());
        Assert.assertNull((Object)cmd.getOutputs());
    }

    @Test
    public void shouldFailOnInvalidArguments() {
        Command cmd = new Command(Arrays.asList(COMMAND, "invalid_argument"));
        cmd.execute();
        Assert.assertTrue((cmd.getExitStatus() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cmd.wasStarted());
        Assert.assertTrue((boolean)cmd.isCompleted());
        Assert.assertNull((Object)cmd.getException());
        Assert.assertNotNull((Object)cmd.getErrorLines());
        Assert.assertTrue((cmd.getErrorLines().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cmd.getErrors());
        Assert.assertTrue((cmd.getErrors().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cmd.getOutputLines());
        Assert.assertTrue((cmd.getOutputs().size() == 0 ? 1 : 0) != 0);
    }
}

