/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import java.util.Set;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilder;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateBuilderTest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsObjectValidatorTest {
    private ProvisioningCmsObjectValidator subject;
    private ValidationOptions options = ValidationOptions.strictValidation();

    @Before
    public void setUp() throws Exception {
        this.subject = new ProvisioningCmsObjectValidator(this.options, ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject(), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
    }

    @Test
    public void shouldValidateValidObject() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject.validate(validationResult);
        Assert.assertFalse((boolean)validationResult.hasFailures());
    }

    @Test
    public void shouldHaveValidatedLocationsForAllObjects() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject.validate(validationResult);
        Set validatedLocations = validationResult.getValidatedLocations();
        Assert.assertTrue((boolean)validatedLocations.contains(new ValidationLocation("<cms>")));
        Assert.assertTrue((boolean)validatedLocations.contains(new ValidationLocation("<crl>")));
        Assert.assertTrue((boolean)validatedLocations.contains(new ValidationLocation("<cms-cert>")));
        Assert.assertTrue((boolean)validatedLocations.contains(new ValidationLocation("<identity-cert>")));
    }

    @Test
    public void shouldStopIfCmsObjectIsBadlyFormatted() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        this.subject = new ProvisioningCmsObjectValidator(this.options, new ProvisioningCmsObject(new byte[]{0}, null, null, null, null), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        this.subject.validate(validationResult);
        Assert.assertTrue((boolean)validationResult.hasFailures());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfCmsObjectDoesNotContainAnyCACertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        ProvisioningCmsObjectBuilder builder = new ProvisioningCmsObjectBuilder().withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()).withCrl(ProvisioningObjectMother.CRL);
        this.subject = new ProvisioningCmsObjectValidator(this.options, builder.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate()), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        this.subject.validate(validationResult);
        Assert.assertTrue((boolean)validationResult.hasFailures());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFaiIfCmsObjectContainsMultipleCACertificate() {
        ValidationResult validationResult = ValidationResult.withLocation((String)"n/a");
        ProvisioningCmsObjectBuilder builder = new ProvisioningCmsObjectBuilder().withCmsCertificate(ProvisioningCmsCertificateBuilderTest.TEST_CMS_CERT.getCertificate()).withCrl(ProvisioningObjectMother.CRL);
        this.subject = new ProvisioningCmsObjectValidator(this.options, builder.build(ProvisioningCmsCertificateBuilderTest.EE_KEYPAIR.getPrivate()), ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        this.subject.validate(validationResult);
    }
}

