/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class X509CertificateUtilTest {
    public static final String CERT_WITH_RRDP_URL = "-----BEGIN CERTIFICATE-----\nMIIFLTCCBBWgAwIBAgIBAjANBgkqhkiG9w0BAQsFADANMQswCQYDVQQDEwJUQTAeFw0xNTAyMDMx\nNDUwMDFaFw0xNjAyMDMxNDUwMDFaMDMxMTAvBgNVBAMTKGJiODgyZmExYTZkMDA5ZTExMmYxMzgx\nMGE5ZGI0YjA0ZGJlNDlkMzYwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCF840qoswP\nSXX07/0e7sGvagP7gBxoRjfGDsqjQ+Jj1uy2VNMeaeciFxrYRPmLPz8qNXYp11Q522tw33bM8Syl\n6p1AxjFD+mzj4Zes1xm6OSFo7DUPk7qlk3kvbOUoEVNpJL9kZMhc0F3gY5Sq6zNcR2CtiI5tHD3x\nffIMQ+XVN1WcXkoGE96gm2GJmgvfUeEZo6fROLm9grIQDxIMmEF2GJemD/VEEgIjR4vjjqb0KcRY\n39fbHGrcJJND4qF3aYjmL7ZH4UKADtb6sxqAssyCiv1sNbFjHId8BjBlU2Xv+lf8Oe0qsSwXfdFj\n82qiJPv1NpRrlLlmR1z/hy5tDIhHAgMBAAGjggJwMIICbDAdBgNVHQ4EFgQUu4gvoabQCeES8TgQ\nqdtLBNvknTYwHwYDVR0jBBgwFoAU1y0ME/5462WgNp2rJAZwjNjnBfkwDwYDVR0TAQH/BAUwAwEB\n/zAOBgNVHQ8BAf8EBAMCAQYwQwYIKwYBBQUHAQEENzA1MDMGCCsGAQUFBzAChidodHRwOi8vbG9j\nYWxob3N0OjgwODAvcnBraS1jYS90YS90YS5jZXIwggEsBggrBgEFBQcBCwSCAR4wggEaMFYGCCsG\nAQUFBzAFhkpyc3luYzovL2xvY2FsaG9zdDoxMDg3My9yZXBvLzNhODdhNGIxLTZlMjItNGE2My1h\nZDBmLTA2ZjgzYWQzY2ExNi9kZWZhdWx0LzCBggYIKwYBBQUHMAqGdnJzeW5jOi8vbG9jYWxob3N0\nOjEwODczL3JlcG8vM2E4N2E0YjEtNmUyMi00YTYzLWFkMGYtMDZmODNhZDNjYTE2L2RlZmF1bHQv\nYmI4ODJmYTFhNmQwMDllMTEyZjEzODEwYTlkYjRiMDRkYmU0OWQzNi5tZnQwOwYIKwYBBQUHMA2G\nL2h0dHA6Ly9sb2NhbGhvc3Q6ODA4MC9ycGtpLWNhL25vdGlmeS9ub3RpZnkueG1sMFoGA1UdHwRT\nMFEwT6BNoEuGSXJzeW5jOi8vbG9jYWxob3N0OjEwODczL3JlcG8vZDcyZDBjMTNmZTc4ZWI2NWEw\nMzY5ZGFiMjQwNjcwOGNkOGU3MDVmOS5jcmwwGAYDVR0gAQH/BA4wDDAKBggrBgEFBQcOAjAeBggr\nBgEFBQcBBwEB/wQPMA0wCwQCAAEwBQMDAMCoMA0GCSqGSIb3DQEBCwUAA4IBAQAxP3d4m66BZT1p\nyZcWeZeagSLD5jsXBZnrr9I62GDgWBMnrEL1euf8K6ZdaM7JZCiiuTtrseugTH4u1T81dtOD0E7X\n7ssK9dqExPaVRipE50AM4HZC4DSXh3NoQIaDrcPEVuqFCUF/P9Po7hq+JkzBSQDRuDNjBYgarzA/\nPdApSo+fQPHH8g28g24i9gn4CJDcc1g5UQVP4wCXn/Mmw7ZNrhwI12YqCQdNTID6Mx5gIFHlogCT\ncu3tN8Q36mohcdxFv/PM1nLY6IJ/+ym0xIfs51khS26/Nrf/jXMLXakIdonD8bRCzm47H6NTkwD3\nbzE3V+I05l3rdFdzd/6Nh2Ya-----END CERTIFICATE-----";

    @Test
    public void shouldGetEncodedSubjectPublicKeyInfo() throws CertificateEncodingException, IOException {
        X509ResourceCertificate cert1 = X509ResourceCertificateTest.createSelfSignedCaCertificateBuilder().withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES).build();
        String encoded1 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)cert1.getCertificate());
        X509ResourceCertificate cert2 = X509ResourceCertificateTest.createSelfSignedCaCertificateBuilder().withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES).build();
        String encoded2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)cert2.getCertificate());
        Assert.assertNotNull((Object)encoded1);
        Assert.assertNotSame((Object)encoded1, (Object)encoded2);
    }

    @Test
    @Ignore
    public void shouldParseRrdpRepositoryUrl() throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(IOUtils.toInputStream((String)CERT_WITH_RRDP_URL));
        URI rrdpNotifyUri = X509CertificateUtil.getRrdpNotifyUri((X509Certificate)certificate);
        Assert.assertEquals((Object)URI.create("http://localhost:8080/rpki-ca/notify/notify.xml"), (Object)rrdpNotifyUri);
    }
}

