/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.manifest;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ManifestCmsTest {
    private static final URI ROOT_CERTIFICATE_LOCATION = URI.create("rsync://foo.host/bar/bar.cer");
    private static final URI ROOT_SIA_MANIFEST_RSYNC_LOCATION = URI.create("rsync://foo.host/bar/manifest.mft");
    private static final URI ROOT_MANIFEST_CRL_LOCATION = URI.create("rsync://foo.host/bar/bar.crl");
    private static final IpResourceSet ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    public static final KeyPair ROOT_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    public static final KeyPair MANIFEST_KEY_PAIR = KeyPairFactoryTest.SECOND_TEST_KEY_PAIR;
    private static final X500Principal MANIFEST_DN = new X500Principal("CN=manifest");
    private static byte[] FILE1_CONTENTS = new byte[]{97, 98, 99};
    private static byte[] FILE2_CONTENTS = new byte[]{100, 101, 102};
    private static final DateTime THIS_UPDATE_TIME = new DateTime(2008, 9, 1, 22, 43, 29, 0, DateTimeZone.UTC);
    private static final DateTime MFT_EE_NOT_BEFORE = THIS_UPDATE_TIME.minusMinutes(5);
    private static final DateTime NEXT_UPDATE_TIME = THIS_UPDATE_TIME.plusHours(24);
    private static final DateTime MFT_EE_NOT_AFTER = THIS_UPDATE_TIME.plusDays(7);
    private static Map<String, byte[]> files = new HashMap<String, byte[]>();
    private CrlLocator crlLocator;
    private ManifestCms subject;
    private X509ResourceCertificate rootCertificate;
    private static final ValidationOptions VALIDATION_OPTIONS;

    public static ManifestCms getRootManifestCms() {
        ManifestCmsBuilder builder = ManifestCmsTest.getRootManifestBuilder();
        for (Map.Entry<String, byte[]> entry : files.entrySet()) {
            builder.addFile(entry.getKey(), entry.getValue());
        }
        return builder.build(MANIFEST_KEY_PAIR.getPrivate());
    }

    @Before
    public void setUp() {
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.getMillis());
        this.rootCertificate = this.getRootResourceCertificate();
        this.crlLocator = (CrlLocator)Mockito.mock(CrlLocator.class);
        this.subject = ManifestCmsTest.getRootManifestCms();
    }

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void shouldVerifySignature() {
        Assert.assertTrue((boolean)this.subject.signedBy(this.subject.getCertificate()));
    }

    @Test
    public void shouldVerifyFileContents() {
        Assert.assertTrue((boolean)this.subject.verifyFileContents("filename1", FILE1_CONTENTS));
        Assert.assertFalse((boolean)this.subject.verifyFileContents("filename2", FILE1_CONTENTS));
        ManifestCms.FileContentSpecification spec = this.subject.getFileContentSpecification("filename2");
        Assert.assertTrue((boolean)spec.isSatisfiedBy(FILE2_CONTENTS));
        Assert.assertFalse((boolean)spec.isSatisfiedBy(FILE1_CONTENTS));
    }

    @Test
    public void shouldValidateManifestCms() {
        X509Crl crl = this.getRootCrl();
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        Assert.assertEquals((long)0L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertFalse((boolean)result.hasFailures());
    }

    @Test
    public void shouldNotValidateWithInvalidCrl() {
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        final ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        result.setLocation(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION));
        final ValidationLocation rootMftCrlValidationLocation = new ValidationLocation(ROOT_MANIFEST_CRL_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenAnswer((Answer)new Answer<X509Crl>(){

            public X509Crl answer(InvocationOnMock invocationOnMock) throws Throwable {
                Assert.assertEquals((Object)rootMftCrlValidationLocation, (Object)result.getCurrentLocation());
                result.rejectIfFalse(false, "cert.crl.signature");
                return null;
            }
        });
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        Assert.assertTrue((boolean)result.hasFailureForCurrentLocation());
        Assert.assertEquals((Object)new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), (Object)result.getCurrentLocation());
        Assert.assertTrue((boolean)result.hasFailureForLocation(rootMftCrlValidationLocation));
        Assert.assertTrue((boolean)result.getAllValidationChecksForLocation(new ValidationLocation(ROOT_MANIFEST_CRL_LOCATION)).contains(new ValidationCheck(ValidationStatus.ERROR, "cert.crl.signature", new String[0])));
    }

    @Test
    public void shouldWarnWhenManifestIsStale() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.withStaleConfigurations((Duration)Duration.ZERO, (Duration)Duration.standardDays((long)36500L));
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        Assert.assertFalse((boolean)result.hasFailures());
        Assert.assertEquals((long)0L, (long)result.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.WARNING, "mf.past.next.update", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.past.next.update"));
    }

    @Test
    public void shouldRejectWhenManifestIsTooStaleDueToNegativeGracePeriod() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.minusDays(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.withStaleConfigurations((Duration)Duration.ZERO, (Duration)Duration.standardDays((long)-2L));
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.past.next.update", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.past.next.update"));
    }

    @Test
    public void shouldRejectWhenThisUpdateTimeIsNotBeforeNextUpdateTime() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(1).getMillis());
        this.subject = ManifestCmsTest.getRootManifestBuilder().withThisUpdateTime(NEXT_UPDATE_TIME.plusSeconds(1)).build(MANIFEST_KEY_PAIR.getPrivate());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        this.subject.validateWithCrl(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toASCIIString(), context, ValidationOptions.strictValidation(), result, crl);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.this.update.before.next.update", new String[]{NEXT_UPDATE_TIME.plusSeconds(1).toString(), NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.this.update.before.next.update"));
    }

    @Test
    public void shouldRejectWhenManifestIsTooStale() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.withStaleConfigurations((Duration)Duration.ZERO, (Duration)Duration.ZERO);
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.past.next.update", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.past.next.update"));
    }

    @Test
    public void shouldRejectWhenCertificateIsExpired() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)NEXT_UPDATE_TIME.plusDays(8).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.withStaleConfigurations((Duration)Duration.ZERO, (Duration)Duration.standardDays((long)100L));
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.WARNING, "mf.past.next.update", new String[]{NEXT_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.past.next.update"));
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "cert.not.valid.after", new String[]{MFT_EE_NOT_AFTER.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "cert.not.valid.after"));
    }

    @Test
    public void shouldRejectWhenThisUpdateInFuture() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.minusSeconds(1).getMillis());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.backCompatibleRipeNccValidator();
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, options, result);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.before.this.update", new String[]{THIS_UPDATE_TIME.toString()}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.before.this.update"));
    }

    @Test
    public void shouldRejectFileNamesThatEscapeRepository() {
        X509Crl crl = this.getRootCrl();
        DateTimeUtils.setCurrentMillisFixed((long)THIS_UPDATE_TIME.minusSeconds(1).getMillis());
        ManifestCmsBuilder builder = ManifestCmsTest.getRootManifestBuilder();
        builder.addFile("this-one-is-ok.roa", new byte[0]);
        builder.addFile("underscore_is_also_allowed_since_there_are_published_objects", new byte[0]);
        builder.addFile("", new byte[0]);
        builder.addFile("   ", new byte[0]);
        builder.addFile("\u0000", new byte[0]);
        builder.addFile(".", new byte[0]);
        builder.addFile("..", new byte[0]);
        builder.addFile("...", new byte[0]);
        builder.addFile("cannot-contain-a/slash", new byte[0]);
        this.subject = builder.build(MANIFEST_KEY_PAIR.getPrivate());
        IpResourceSet resources = this.rootCertificate.getResources();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate, resources, (List)Lists.newArrayList((Object[])new String[]{this.rootCertificate.getSubject().getName()}));
        ValidationOptions options = ValidationOptions.strictValidation();
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        this.subject.validateWithCrl(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, options, result, crl);
        Assert.assertTrue((boolean)result.hasFailures());
        Assert.assertEquals((Object)new ValidationCheck(ValidationStatus.ERROR, "mf.entry.file.name.is.relative", new String[]{", \\u0000,    , ., .., cannot-contain-a/slash"}), (Object)result.getResult(new ValidationLocation(ROOT_SIA_MANIFEST_RSYNC_LOCATION), "mf.entry.file.name.is.relative"));
    }

    @Test
    public void shouldMatchFiles() {
        ManifestCms mft = ManifestCmsTest.getRootManifestCms();
        Assert.assertTrue((boolean)mft.matchesFiles(files));
    }

    @Test
    public void shouldNotMatchIfFilesMissing() {
        ManifestCms mft = ManifestCmsTest.getRootManifestCms();
        Map emptyFiles = Collections.emptyMap();
        Assert.assertFalse((boolean)mft.matchesFiles(emptyFiles));
    }

    @Test
    public void shouldNotMatchIfAdditionalFilesPresent() {
        ManifestCms mft = ManifestCmsTest.getRootManifestCms();
        HashMap<String, byte[]> wrongFiles = new HashMap<String, byte[]>(files);
        wrongFiles.put("newfile", FILE1_CONTENTS);
        Assert.assertFalse((boolean)mft.matchesFiles(wrongFiles));
    }

    @Test
    public void shouldNotMatchIfFileContentChanged() {
        ManifestCms mft = ManifestCmsTest.getRootManifestCms();
        HashMap<String, byte[]> wrongFiles = new HashMap<String, byte[]>(files);
        wrongFiles.put("filename2", FILE1_CONTENTS);
        Assert.assertFalse((boolean)mft.matchesFiles(wrongFiles));
    }

    @Test
    public void shouldPastValidityTimeForCmsBeTheSameAsTheCertificate() {
        ManifestCms subject = ManifestCmsTest.getRootManifestCms();
        Assert.assertEquals((Object)subject.getCertificate().isPastValidityTime(), (Object)subject.isPastValidityTime());
    }

    @Test
    public void shouldBeRevoked() {
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(ROOT_CERTIFICATE_LOCATION, this.rootCertificate);
        ValidationResult result = ValidationResult.withLocation((URI)ROOT_SIA_MANIFEST_RSYNC_LOCATION);
        X509Crl crl = this.getRootCrlBuilder().addEntry(this.subject.getCertificate().getSerialNumber(), DateTime.now().minusMinutes(1)).build(ROOT_KEY_PAIR.getPrivate());
        Mockito.when((Object)this.crlLocator.getCrl(ROOT_MANIFEST_CRL_LOCATION, context, result)).thenReturn((Object)crl);
        this.subject.validate(ROOT_SIA_MANIFEST_RSYNC_LOCATION.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        Assert.assertTrue((boolean)this.subject.isRevoked());
    }

    private X509Crl getRootCrl() {
        return this.getRootCrlBuilder().build(ROOT_KEY_PAIR.getPrivate());
    }

    private X509ResourceCertificate getRootResourceCertificate() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        builder.withResources(ROOT_RESOURCE_SET);
        builder.withPublicKey(ROOT_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        X509CertificateInformationAccessDescriptor[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, ROOT_SIA_MANIFEST_RSYNC_LOCATION)};
        builder.withSubjectInformationAccess(descriptors);
        builder.withCrlDistributionPoints(new URI[]{ROOT_MANIFEST_CRL_LOCATION});
        return builder.build();
    }

    private X509CrlBuilder getRootCrlBuilder() {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(X509ResourceCertificateTest.TEST_SELF_SIGNED_CERTIFICATE_NAME);
        DateTime now = UTC.dateTime();
        builder.withThisUpdateTime(NEXT_UPDATE_TIME.minusHours(24));
        builder.withNextUpdateTime(NEXT_UPDATE_TIME.plusHours(24));
        builder.withNumber(BigInteger.TEN);
        builder.withAuthorityKeyIdentifier(ROOT_KEY_PAIR.getPublic());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    public static ManifestCmsBuilder getRootManifestBuilder() {
        return ManifestCmsTest.getRootManifestBuilder(new ValidityPeriod((ReadableInstant)THIS_UPDATE_TIME, (ReadableInstant)NEXT_UPDATE_TIME));
    }

    public static ManifestCmsBuilder getRootManifestBuilder(ValidityPeriod validityPeriod) {
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.withCertificate(ManifestCmsTest.getManifestEEResourceCertificateBuilder().build());
        builder.withManifestNumber(BigInteger.valueOf(68L));
        builder.withThisUpdateTime(validityPeriod.getNotValidBefore()).withNextUpdateTime(validityPeriod.getNotValidAfter());
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private static X509ResourceCertificateBuilder getManifestEEResourceCertificateBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false);
        builder.withKeyUsage(128);
        builder.withSubjectDN(MANIFEST_DN);
        builder.withIssuerDN(X509ResourceCertificateTest.TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withSerial(BigInteger.ONE);
        builder.withPublicKey(MANIFEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(ROOT_KEY_PAIR);
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)MFT_EE_NOT_BEFORE, (ReadableInstant)MFT_EE_NOT_AFTER));
        builder.withCrlDistributionPoints(new URI[]{ROOT_MANIFEST_CRL_LOCATION});
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, ROOT_SIA_MANIFEST_RSYNC_LOCATION)});
        return builder;
    }

    static {
        files.put("filename1", FILE1_CONTENTS);
        files.put("filename2", FILE2_CONTENTS);
        VALIDATION_OPTIONS = ValidationOptions.strictValidation();
    }
}

