/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Set;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.rfc8209.RouterExtensionEncoder;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public abstract class X509CertificateParser<T extends AbstractX509CertificateWrapper> {
    private static final String[] ALLOWED_SIGNATURE_ALGORITHM_OIDS = new String[]{PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()};
    protected X509Certificate certificate;
    protected ValidationResult result;

    public void parse(String location, byte[] encoded) {
        this.parse(ValidationResult.withLocation(location), encoded);
    }

    public void parse(ValidationResult validationResult, byte[] encoded) {
        this.result = validationResult;
        X509Certificate certificate = X509CertificateParser.parseEncoded(encoded, this.result);
        this.validateX509Certificate(validationResult, certificate);
    }

    public void validateX509Certificate(ValidationResult validationResult, X509Certificate certificate) {
        this.certificate = certificate;
        this.result = validationResult;
        if (!validationResult.hasFailureForCurrentLocation()) {
            this.validateSignatureAlgorithm();
            this.validatePublicKey();
            this.doTypeSpecificValidation();
        }
    }

    public static X509GenericCertificate parseCertificate(ValidationResult result, byte[] encoded) {
        X509Certificate certificate = X509CertificateParser.parseEncoded(encoded, result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        X509CertificateParser parser = X509CertificateUtil.isRouter(certificate) ? new X509RouterCertificateParser() : new X509ResourceCertificateParser();
        parser.validateX509Certificate(result, certificate);
        return result.hasFailureForCurrentLocation() ? null : (X509GenericCertificate)parser.getCertificate();
    }

    protected void validatePublicKey() {
        this.validateRsaPk();
    }

    void validateRsaPk() {
        PublicKey publicKey = this.certificate.getPublicKey();
        boolean rsaPk = this.isRsaPk(publicKey);
        this.result.rejectIfFalse(rsaPk, "cert.public.key.algorithm", publicKey.getAlgorithm());
        if (rsaPk) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            this.result.warnIfFalse(2048 == rsaPublicKey.getModulus().bitLength(), "cert.public.key.size", String.valueOf(rsaPublicKey.getModulus().bitLength()));
        }
    }

    boolean isRsaPk(PublicKey publicKey) {
        return "RSA".equals(publicKey.getAlgorithm()) && publicKey instanceof RSAPublicKey;
    }

    boolean isEcPk(PublicKey publicKey) {
        return "EC".equals(publicKey.getAlgorithm()) && publicKey instanceof ECPublicKey;
    }

    void validateEcPk() {
        PublicKey publicKey = this.certificate.getPublicKey();
        this.result.rejectIfFalse(this.isEcPk(publicKey), "cert.public.key.algorithm", publicKey.getAlgorithm());
    }

    protected void doTypeSpecificValidation() {
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }

    public boolean isSuccess() {
        return !this.result.hasFailures();
    }

    public abstract T getCertificate();

    protected X509Certificate getX509Certificate() {
        return this.certificate;
    }

    private static X509Certificate parseEncoded(byte[] encoded, ValidationResult result) {
        X509Certificate certificate = X509CertificateParser.parseX509Certificate(encoded);
        result.rejectIfNull(certificate, "cert.parsed");
        return certificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate parseX509Certificate(byte[] encoded) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(encoded);){
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(input);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            return null;
        }
    }

    private void validateSignatureAlgorithm() {
        this.result.rejectIfFalse(ArrayUtils.contains((Object[])ALLOWED_SIGNATURE_ALGORITHM_OIDS, (Object)this.certificate.getSigAlgOID()), "cert.signature.algorithm", this.certificate.getSigAlgOID());
    }

    protected boolean isResourceExtensionPresent() {
        Set<String> criticalExtensionOIDs = this.certificate.getCriticalExtensionOIDs();
        if (criticalExtensionOIDs == null) {
            return false;
        }
        return criticalExtensionOIDs.contains(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId()) || criticalExtensionOIDs.contains(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId());
    }

    protected boolean isIpResourceExtensionPresent() {
        if (this.certificate.getCriticalExtensionOIDs() == null) {
            return false;
        }
        return this.certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId());
    }

    protected boolean isAsResourceExtensionPresent() {
        if (this.certificate.getCriticalExtensionOIDs() == null) {
            return false;
        }
        return this.certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId());
    }

    protected boolean isBgpSecExtensionPresent() {
        try {
            List<String> extendedKeyUsage = this.certificate.getExtendedKeyUsage();
            return extendedKeyUsage != null && extendedKeyUsage.contains(RouterExtensionEncoder.OID_KP_BGPSEC_ROUTER.getId());
        }
        catch (CertificateParsingException e) {
            return false;
        }
    }
}

