/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.util.Asn1UtilException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;

public final class Asn1Util {
    private Asn1Util() {
    }

    public static byte[] encode(ASN1Encodable value) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream derOutputStream = ASN1OutputStream.create((OutputStream)byteArrayOutputStream, (String)"DER");
            derOutputStream.writeObject(value);
            derOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new Asn1UtilException("IO exception while encoding resource extension", e);
        }
    }

    public static DERBitString resourceToBitString(UniqueIpResource resource, int bitCount) {
        byte[] padded;
        int resourceTypeByteSize = resource.getType().getBitSize() / 8;
        byte[] value = resource.getValue().toByteArray();
        if (value.length > resourceTypeByteSize) {
            padded = Arrays.copyOfRange(value, 1, value.length);
        } else if (value.length < resourceTypeByteSize) {
            padded = new byte[resourceTypeByteSize];
            System.arraycopy(value, 0, padded, resourceTypeByteSize - value.length, value.length);
        } else {
            padded = value;
        }
        assert (padded.length == resourceTypeByteSize) : "incorrect padded length";
        int byteCount = (bitCount + 8 - 1) / 8;
        int unusedBits = 7 - (bitCount + 8 - 1) % 8;
        return new DERBitString(ArrayUtils.subarray((byte[])padded, (int)0, (int)byteCount), unusedBits);
    }

    public static ASN1Primitive decode(byte[] extension) {
        try {
            ASN1InputStream is = new ASN1InputStream(extension);
            return is.readObject();
        }
        catch (IOException e) {
            throw new Asn1UtilException("IO exception while decoding resource extension", e);
        }
    }

    public static <T extends ASN1Encodable> T expect(ASN1Encodable value, Class<? extends T> expectedClass) {
        if (value != null) {
            try {
                return (T)((ASN1Encodable)expectedClass.cast(value));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(expectedClass.getSimpleName() + " expected, got " + value.getClass().getSimpleName() + " with value: " + value);
            }
        }
        throw new IllegalArgumentException(expectedClass.getSimpleName() + " expected, got null");
    }

    public static IpRange parseIpAddressAsPrefix(IpResourceType type, ASN1Encodable der) {
        Asn1Util.expect(der, DERBitString.class);
        DERBitString derBitString = (DERBitString)der;
        IpAddress ipAddress = Asn1Util.parseIpAddress(type, (ASN1Encodable)derBitString, false);
        int padBits = derBitString.getPadBits();
        return IpRange.prefix((IpAddress)ipAddress, (int)(derBitString.getBytes().length * 8 - padBits));
    }

    public static IpAddress parseIpAddress(IpResourceType type, ASN1Encodable der, boolean padWithOnes) {
        Asn1Util.expect(der, DERBitString.class);
        DERBitString derBitString = (DERBitString)der;
        byte[] bytes = derBitString.getBytes();
        BigInteger value = new BigInteger(1, bytes);
        int usedBits = bytes.length * 8;
        int neededBits = type.getBitSize();
        int padBits = derBitString.getPadBits();
        if (padBits > 0) {
            byte lastByte = bytes[bytes.length - 1];
            byte mask = (byte)((1 << padBits) - 1);
            Validate.isTrue(((lastByte & mask) == 0 ? 1 : 0) != 0, (String)"pad bits not zero");
        }
        BigInteger upperBits = value.shiftLeft(neededBits - usedBits);
        BigInteger lowerBits = BigInteger.ZERO;
        if (padWithOnes) {
            lowerBits = BigInteger.ONE.shiftLeft(neededBits - usedBits + padBits).subtract(BigInteger.ONE);
        }
        return (IpAddress)type.fromBigInteger(upperBits.or(lowerBits));
    }

    public static Asn parseAsId(ASN1Encodable der) {
        return new Asn(Asn1Util.expect(der, ASN1Integer.class).getValue());
    }

    public static DERBitString encodeIpAddress(IpRange prefix) {
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)("not a legal prefix: " + prefix));
        return Asn1Util.resourceToBitString(prefix.getStart(), prefix.getPrefixLength());
    }
}

