/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.serialization;

import com.thoughtworks.xstream.converters.Converter;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.provisioning.serialization.ProvisioningIdentityCertificateXstreamConverter;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import net.ripe.rpki.commons.xml.XStreamXmlSerializerBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningIdentityCertificateXstreamConverterTest {
    private XStreamXmlSerializer<ProvisioningIdentityCertificate> serializer;

    @Before
    public void given() {
        XStreamXmlSerializerBuilder xStreamXmlSerializerBuilder = XStreamXmlSerializerBuilder.newForgivingXmlSerializerBuilder(ProvisioningIdentityCertificate.class);
        xStreamXmlSerializerBuilder.withConverter((Converter)new ProvisioningIdentityCertificateXstreamConverter());
        xStreamXmlSerializerBuilder.withAliasType("ProvisioningIdentityCertificate", ProvisioningIdentityCertificate.class);
        this.serializer = xStreamXmlSerializerBuilder.build();
    }

    @Test
    public void shouldRoundTripSerialize() {
        ProvisioningIdentityCertificate cert = ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT;
        String xml = this.serializer.serialize((Object)cert);
        ProvisioningIdentityCertificate deserializedCert = (ProvisioningIdentityCertificate)this.serializer.deserialize(xml);
        Assert.assertEquals((Object)cert, (Object)deserializedCert);
    }

    @Test
    public void shouldProduceSimpleXml() {
        ProvisioningIdentityCertificate cert = ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT;
        String xml = this.serializer.serialize((Object)cert);
        String expectedRegex = "<ProvisioningIdentityCertificate>\n  <encoded>[^<]*</encoded>\n</ProvisioningIdentityCertificate>";
        Assert.assertTrue((boolean)Pattern.matches(expectedRegex, xml));
    }
}

