/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class X509ResourceCertificateParser
extends X509CertificateParser<X509ResourceCertificate> {
    @Override
    public X509ResourceCertificate getCertificate() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Resource Certificate validation failed");
        }
        return new X509ResourceCertificate(this.getX509Certificate());
    }

    @Override
    protected void doTypeSpecificValidation() {
        this.validateIssuerAndSubjectDN();
        this.validateCertificatePolicy();
        this.validateResourceExtensions();
        this.validateCrlDistributionPoints();
        this.validateSubjectInformationAccess();
    }

    private void validateIssuerAndSubjectDN() {
        X500Name issuer = X500Name.getInstance((Object)this.certificate.getIssuerX500Principal().getEncoded());
        this.getValidationResult().rejectIfFalse(this.isValidName(issuer), "cert.issuer.correct", this.certificate.getIssuerX500Principal().toString());
        X500Name subject = X500Name.getInstance((Object)this.certificate.getSubjectX500Principal().getEncoded());
        this.getValidationResult().rejectIfFalse(this.isValidName(subject), "cert.subject.correct", this.certificate.getSubjectX500Principal().toString());
    }

    private boolean isValidName(X500Name principal) {
        return this.hasOneValidCn(principal) && this.mayHaveOneValidSerialNumber(principal);
    }

    public boolean mayHaveOneValidSerialNumber(X500Name principal) {
        RDN[] serialNumbers = principal.getRDNs(BCStyle.SERIALNUMBER);
        if (serialNumbers.length == 0) {
            return true;
        }
        return serialNumbers.length == 1 && this.isPrintableString(serialNumbers[0]);
    }

    private boolean hasOneValidCn(X500Name principal) {
        RDN[] cns = principal.getRDNs(BCStyle.CN);
        return cns.length == 1 && this.isPrintableString(cns[0]);
    }

    private boolean isPrintableString(RDN rdn) {
        if (rdn.size() != 1) {
            return false;
        }
        AttributeTypeAndValue first = rdn.getFirst();
        ASN1Encodable firstValue = first.getValue();
        if (!this.isPrintableString(firstValue) && !this.isUTF8String(firstValue)) {
            return false;
        }
        String value = firstValue.toString();
        return DERPrintableString.isPrintableString((String)value);
    }

    private boolean isPrintableString(ASN1Encodable value) {
        return value instanceof DERPrintableString;
    }

    private boolean isUTF8String(ASN1Encodable value) {
        return value instanceof DERUTF8String;
    }

    private void validateCertificatePolicy() {
        Set<String> criticalExtensionOIDs = this.certificate.getCriticalExtensionOIDs();
        if (!this.result.rejectIfNull(criticalExtensionOIDs, "cert.critical.exts.present")) {
            return;
        }
        this.result.rejectIfFalse(criticalExtensionOIDs.contains(Extension.certificatePolicies.getId()), "cert.policy.ext.critical");
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(Extension.certificatePolicies.getId());
            if (!this.result.rejectIfNull(extensionValue, "cert.policy.ext.value")) {
                return;
            }
            ASN1Sequence policies = ASN1Sequence.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue));
            if (!this.result.rejectIfFalse(policies.size() == 1, "cert.single.cert.policy")) {
                return;
            }
            PolicyInformation policy = PolicyInformation.getInstance((Object)policies.getObjectAt(0));
            if (!this.result.rejectIfNull(policy.getPolicyIdentifier(), "cert.policy.id.present")) {
                return;
            }
            this.result.rejectIfFalse(AbstractX509CertificateWrapper.POLICY_OID.equals((ASN1Primitive)policy.getPolicyIdentifier()), "cert.policy.id.version");
        }
        catch (IOException e) {
            this.result.rejectIfFalse(false, "cert.policy.validation");
        }
    }

    private void validateResourceExtensions() {
        if (this.result.rejectIfFalse(this.isResourceExtensionPresent(), "cert.resource.ext.present")) {
            this.result.rejectIfTrue(false, "cert.as.or.ip.resource.present");
        }
    }

    private void validateCrlDistributionPoints() {
        CRLDistPoint crlDistPoint;
        byte[] extensionValue = this.certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (X509CertificateUtil.isRoot(this.certificate)) {
            this.result.warnIfNotNull(extensionValue, "cert.crldp.omitted");
            return;
        }
        if (!this.result.rejectIfNull(extensionValue, "cert.crldp.present")) {
            return;
        }
        try {
            crlDistPoint = CRLDistPoint.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue));
            this.result.pass("cert.crldp.ext.parsed");
        }
        catch (IOException e) {
            this.result.error("cert.crldp.ext.parsed");
            return;
        }
        this.testCrlDistributionPointsToUrisConversion(crlDistPoint);
        if (!this.result.hasFailureForCurrentLocation()) {
            this.result.rejectIfNull(X509CertificateUtil.findFirstRsyncCrlDistributionPoint(this.certificate), "cert.crldp.rsync.uri.present");
        }
    }

    private void testCrlDistributionPointsToUrisConversion(CRLDistPoint crldp) {
        for (DistributionPoint dp : crldp.getDistributionPoints()) {
            this.result.rejectIfNotNull(dp.getCRLIssuer(), "cert.crldp.issuer.omitted");
            this.result.rejectIfNotNull(dp.getReasons(), "cert.crldp.reasons.omitted");
            if (!this.result.rejectIfNull(dp.getDistributionPoint(), "cert.crldp.present")) {
                return;
            }
            if (!this.result.rejectIfFalse(dp.getDistributionPoint().getType() == 0, "cert.crldp.type.full.name")) {
                return;
            }
            GeneralNames names = (GeneralNames)dp.getDistributionPoint().getName();
            for (GeneralName name : names.getNames()) {
                if (!this.result.rejectIfFalse(name.getTagNo() == 6, "cert.crldp.name.is.a.uri")) {
                    return;
                }
                DERIA5String uri = (DERIA5String)name.getName();
                this.validateURI(uri.toString(), "cert.crldp.uri.syntax");
            }
        }
    }

    private void validateSubjectInformationAccess() {
        Set<String> nonCriticalExtensionOIDs = this.certificate.getNonCriticalExtensionOIDs();
        if (!this.result.rejectIfNull(nonCriticalExtensionOIDs, "cert.non.critical.exts.present")) {
            return;
        }
        this.result.rejectIfFalse(nonCriticalExtensionOIDs.contains(Extension.subjectInfoAccess.getId()), "cert.sia.non.critical.extension");
        byte[] extensionValue = this.certificate.getExtensionValue(Extension.subjectInfoAccess.getId());
        if (!this.result.rejectIfNull(extensionValue, "cert.sia.present")) {
            return;
        }
        ArrayList<AccessDescription> accessDescriptors = new ArrayList<AccessDescription>();
        try {
            ASN1Sequence sia = ASN1Sequence.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue));
            for (ASN1Encodable encodable : sia) {
                accessDescriptors.add(AccessDescription.getInstance((Object)encodable));
            }
            this.result.pass("cert.sia.parsed");
        }
        catch (IOException | IllegalArgumentException e) {
            this.result.error("cert.sia.parsed");
            return;
        }
        if (X509CertificateUtil.isCa(this.certificate)) {
            this.validateSiaForCaCertificate(accessDescriptors);
        } else {
            this.validateSiaForEeCertificate(accessDescriptors);
        }
    }

    private void validateSiaForCaCertificate(List<AccessDescription> accessDescriptors) {
        boolean hasCaRepositorySia = false;
        boolean hasRsyncRepositoryUri = false;
        boolean hasManifestUri = false;
        for (AccessDescription descriptor : accessDescriptors) {
            URI location;
            if (X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY.equals((ASN1Primitive)descriptor.getAccessMethod())) {
                hasCaRepositorySia = true;
                location = this.toUri(descriptor, "cert.sia.uri.syntax");
                if (location == null || !"rsync".equalsIgnoreCase(location.getScheme())) continue;
                hasRsyncRepositoryUri = true;
                continue;
            }
            if (X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST.equals((ASN1Primitive)descriptor.getAccessMethod())) {
                location = this.toUri(descriptor, "cert.sia.uri.syntax");
                if (location == null || !"rsync".equalsIgnoreCase(location.getScheme())) continue;
                hasManifestUri = true;
                continue;
            }
            if (!X509CertificateInformationAccessDescriptor.ID_AD_RPKI_NOTIFY.equals((ASN1Primitive)descriptor.getAccessMethod())) continue;
            location = this.toUri(descriptor, "cert.sia.uri.syntax");
            this.result.rejectIfFalse(location != null && "https".equalsIgnoreCase(location.getScheme()), "cert.sia.rrdp.notify.uri.https", String.valueOf(descriptor.getAccessLocation()));
        }
        this.result.rejectIfFalse(hasCaRepositorySia, "cert.sia.ca.repository.uri.present");
        this.result.rejectIfFalse(hasRsyncRepositoryUri, "cert.sia.ca.repository.rsync.uri.present");
        this.result.rejectIfFalse(hasManifestUri, "cert.sia.manifest.uri.present");
    }

    private void validateSiaForEeCertificate(List<AccessDescription> accessDescriptors) {
        TreeSet<String> otherAccessMethods = new TreeSet<String>();
        boolean hasSignedObjectUri = false;
        for (AccessDescription descriptor : accessDescriptors) {
            URI location;
            if (X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT.equals((ASN1Primitive)descriptor.getAccessMethod())) {
                location = this.toUri(descriptor, "cert.sia.uri.syntax");
                if (location == null || !"rsync".equalsIgnoreCase(location.getScheme())) continue;
                hasSignedObjectUri = true;
                continue;
            }
            if (X509CertificateInformationAccessDescriptor.ID_AD_RPKI_NOTIFY.equals((ASN1Primitive)descriptor.getAccessMethod())) {
                location = this.toUri(descriptor, "cert.sia.uri.syntax");
                this.result.rejectIfFalse(location != null && "https".equalsIgnoreCase(location.getScheme()), "cert.sia.rrdp.notify.uri.https", String.valueOf(descriptor.getAccessLocation()));
                continue;
            }
            otherAccessMethods.add(descriptor.getAccessMethod().getId());
        }
        this.result.rejectIfFalse(hasSignedObjectUri, "cert.sia.signed.object.uri.present");
        this.result.rejectIfFalse(otherAccessMethods.isEmpty(), "cert.sia.ee.certificate.other.access.methods", String.join((CharSequence)", ", otherAccessMethods));
    }

    private URI toUri(AccessDescription descriptor, String key) {
        GeneralName location = descriptor.getAccessLocation();
        if (location.getTagNo() != 6) {
            return null;
        }
        return this.validateURI(location.getName().toString(), key);
    }

    private URI validateURI(String uriString, String key) {
        try {
            URI uri = new URI(uriString);
            URI normalized = uri.normalize();
            this.result.warnIfFalse(uri.equals(normalized), key, uriString);
            return normalized;
        }
        catch (URISyntaxException e) {
            this.result.error(key, uriString);
            return null;
        }
    }
}

