/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml;

import com.thoughtworks.xstream.XStream;
import net.ripe.rpki.commons.xml.AliasedTypePermission;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AliasedTypePermissionTest {
    private XStream xStream;
    private AliasedTypePermission permission;

    @Before
    public void initialize() {
        this.xStream = new XStream();
        this.permission = new AliasedTypePermission(this.xStream);
    }

    @Test
    public void shouldAcceptAliasedTypes() {
        Assert.assertFalse((boolean)this.permission.allows(SerializeMe.class));
        this.xStream.alias("serialize-me", SerializeMe.class);
        Assert.assertTrue((boolean)this.permission.allows(SerializeMe.class));
    }

    @Test
    public void shouldAcceptAliasedPackageMembers() {
        Assert.assertFalse((boolean)this.permission.allows(SerializeMe.class));
        this.xStream.aliasPackage("rpki-commons", "net.ripe.rpki.commons");
        Assert.assertTrue((boolean)this.permission.allows(SerializeMe.class));
    }

    private static class SerializeMe {
        private SerializeMe() {
        }
    }
}

