/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.list.request;

import java.io.IOException;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayload;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadSerializerBuilder;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ResourceClassListQueryPayloadBuilderTest {
    private static final XStreamXmlSerializer<ResourceClassListQueryPayload> SERIALIZER = new ResourceClassListQueryPayloadSerializerBuilder().build();
    public static final ResourceClassListQueryPayload TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD = ResourceClassListQueryPayloadBuilderTest.createResourceClassListQueryPayload();

    private static ResourceClassListQueryPayload createResourceClassListQueryPayload() {
        ResourceClassListQueryPayloadBuilder builder = new ResourceClassListQueryPayloadBuilder();
        return builder.build();
    }

    @Test
    public void shouldCreateParsableProvisioningObject() throws IOException {
        Assert.assertEquals((Object)"sender", (Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD.getRecipient());
    }

    @Test
    public void shouldCreateXmlConformDraft() {
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\" version=\"1\" sender=\"sender\" recipient=\"recipient\" type=\"list\"/>";
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD);
        Assert.assertEquals((Object)expectedXml, (Object)actualXml);
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

