/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import java.io.Serializable;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.util.EqualsSupport;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class RoaPrefix
extends EqualsSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IpRange prefix;
    private final Integer maximumLength;

    public RoaPrefix(IpRange prefix) {
        this(prefix, null);
    }

    public RoaPrefix(IpRange prefix, Integer maximumLength) {
        Validate.notNull((Object)prefix, (String)"prefix is required");
        Validate.isTrue((boolean)prefix.isLegalPrefix(), (String)"prefix is not a legal prefix");
        Validate.isTrue((maximumLength == null || maximumLength >= prefix.getPrefixLength() && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximum length not in range");
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public int getEffectiveMaximumLength() {
        return this.maximumLength != null ? this.maximumLength.intValue() : this.getPrefix().getPrefixLength();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("prefix", (Object)this.getPrefix()).append("maximumLength", (Object)this.maximumLength).toString();
    }
}

