/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilderTest;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectValidator;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.issue.request.CertificateIssuanceRequestPayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.payload.issue.response.CertificateIssuanceResponsePayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.payload.list.request.ResourceClassListQueryPayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.payload.list.response.ResourceClassListResponsePayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.payload.revocation.request.CertificateRevocationRequestPayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayloadBuilderTest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilderTest;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateObjectsForInteropTesting {
    private static final String outputDirPath = "/tmp/provisioning-interop";

    @Before
    public void createOutputDir() {
        File outputDir = new File(outputDirPath);
        outputDir.mkdirs();
    }

    @Test
    public void createObjects() throws IOException {
        this.writeToDisk("identity-cert.cer", ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT.getEncoded());
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)ResourceClassListQueryPayloadBuilderTest.TEST_RESOURCE_CLASS_LIST_QUERY_PAYLOAD, "resource-class-list-query.cms");
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)ResourceClassListResponsePayloadBuilderTest.TEST_RESOURCE_CLASS_LIST_RESPONSE_PAYLOAD, "resource-class-list-response.cms");
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)CertificateIssuanceRequestPayloadBuilderTest.TEST_CERTIFICATE_ISSUANCE_REQUEST_PAYLOAD, "certificate-issuance-request.cms");
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)CertificateIssuanceResponsePayloadBuilderTest.TEST_CERTIFICATE_ISSUANCE_RESPONSE_PAYLOAD, "certificate-issuance-response.cms");
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)CertificateRevocationRequestPayloadBuilderTest.TEST_CERTIFICATE_REVOCATION_REQUEST_PAYLOAD, "certificate-revocation-request.cms");
        this.createValidCmsObjectAndWriteItToDisk((AbstractProvisioningPayload)CertificateRevocationResponsePayloadBuilderTest.TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD, "certificate-revocation-response.cms");
    }

    public void createValidCmsObjectAndWriteItToDisk(AbstractProvisioningPayload payload, String fileName) throws IOException {
        ProvisioningCmsObject resourceClassListQueryCms = ProvisioningCmsObjectBuilderTest.createProvisioningCmsObjectForPayload(payload);
        this.validateCmsObject(resourceClassListQueryCms);
        this.writeToDisk(fileName, resourceClassListQueryCms.getEncoded());
    }

    public void validateCmsObject(ProvisioningCmsObject resourceClassListQueryCms) {
        ProvisioningCmsObjectValidator validator = new ProvisioningCmsObjectValidator(ValidationOptions.strictValidation(), resourceClassListQueryCms, ProvisioningIdentityCertificateBuilderTest.TEST_IDENTITY_CERT);
        ValidationResult result = ValidationResult.withLocation((String)"n/a");
        validator.validate(result);
        Assert.assertTrue((!result.hasFailures() ? 1 : 0) != 0);
    }

    private void writeToDisk(String fileName, byte[] encoded) throws IOException {
        File file = new File("/tmp/provisioning-interop/" + fileName);
        Files.write((byte[])encoded, (File)file);
    }
}

