/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.roa;

import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import org.junit.Assert;
import org.junit.Test;

public class RoaPrefixTest {
    @Test
    public void shouldEnsureIpAddressIsValidPrefix() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0-10.0.2.1"), null);
            Assert.fail((String)"ROA prefix requires legal prefix");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldEnsureMaximumLengthValidity() {
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), null);
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(-1));
            Assert.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(8));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(17));
        new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(32));
        new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(128));
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(0));
            Assert.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(7));
            Assert.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"10.0.0.0/8"), Integer.valueOf(33));
            Assert.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RoaPrefix(IpRange.parse((String)"ffe0::/16"), Integer.valueOf(129));
            Assert.fail((String)"maximum length invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

