/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObjectFile;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.ResourceCertificateLocator;
import net.ripe.rpki.commons.validation.objectvalidators.ResourceValidatorFactory;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateParentChildValidator;
import net.ripe.rpki.commons.validation.objectvalidators.X509ResourceCertificateValidator;

public class X509ResourceCertificateBottomUpValidator
implements X509ResourceCertificateValidator {
    private static final int MAX_CHAIN_LENGTH = 30;
    private X509ResourceCertificate certificate;
    private Collection<X509ResourceCertificate> trustAnchors;
    private ResourceCertificateLocator locator;
    private List<CertificateWithLocation> certificates = new LinkedList<CertificateWithLocation>();
    private ValidationOptions options;
    private ValidationResult result;
    private ValidationLocation location;

    public X509ResourceCertificateBottomUpValidator(ResourceCertificateLocator locator, X509ResourceCertificate ... trustAnchors) {
        this(locator, Arrays.asList(trustAnchors));
    }

    public X509ResourceCertificateBottomUpValidator(ResourceCertificateLocator locator, Collection<X509ResourceCertificate> trustAnchors) {
        this(new ValidationOptions(), ValidationResult.withLocation("unknown.cer"), locator, trustAnchors);
    }

    public X509ResourceCertificateBottomUpValidator(ValidationOptions options, ValidationResult result, ResourceCertificateLocator locator, Collection<X509ResourceCertificate> trustAnchors) {
        this.options = options;
        this.result = result;
        this.location = new ValidationLocation("unknown.cer");
        this.locator = locator;
        this.trustAnchors = trustAnchors;
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.result;
    }

    @Override
    public void validate(String location, X509ResourceCertificate certificate) {
        this.location = new ValidationLocation(location);
        this.certificate = certificate;
        this.buildCertificationList();
        if (this.result.hasFailures()) {
            return;
        }
        this.checkTrustAnchor();
        X509ResourceCertificate parent = this.certificates.get(0).getCertificate();
        this.certificates.remove(0);
        IpResourceSet resources = parent.getResources();
        for (CertificateWithLocation certificateWithLocation : this.certificates) {
            String childLocation = certificateWithLocation.getLocation().getName();
            X509ResourceCertificate child = certificateWithLocation.getCertificate();
            X509Crl crl = this.getCRL(child, this.result);
            if (this.result.hasFailures()) {
                return;
            }
            X509ResourceCertificateParentChildValidator validator = ResourceValidatorFactory.getX509ResourceCertificateParentChildStrictValidator(this.options, this.result, parent, resources, crl);
            validator.validate(childLocation, child);
            resources = child.deriveResources(resources);
            parent = child;
        }
    }

    private void buildCertificationList() {
        this.certificates.add(0, new CertificateWithLocation(this.certificate, this.location));
        this.result.setLocation(this.location);
        if (!this.result.rejectIfFalse(this.certificates.size() <= 30, "cert.chain.length", Integer.valueOf(30).toString())) {
            return;
        }
        X509ResourceCertificate cert = this.certificate;
        while (!cert.isRoot()) {
            CertificateRepositoryObjectFile<X509ResourceCertificate> parent = this.locator.findParent(cert);
            if (!this.result.rejectIfNull(parent, "cert.chain.complete")) {
                return;
            }
            X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
            parser.parse(ValidationResult.withLocation(parent.getName()), parent.getContent());
            if (this.result.hasFailures()) {
                return;
            }
            cert = parser.getCertificate();
            ValidationLocation parentLocation = new ValidationLocation(parent.getName());
            this.certificates.add(0, new CertificateWithLocation(cert, parentLocation));
            this.result.setLocation(parentLocation);
            if (this.result.rejectIfFalse(this.certificates.size() <= 30, "cert.chain.length", Integer.valueOf(30).toString())) continue;
            return;
        }
    }

    private X509Crl getCRL(X509ResourceCertificate certificate, ValidationResult validationResult) {
        CertificateRepositoryObjectFile<X509Crl> crlFile = this.locator.findCrl(certificate);
        if (crlFile == null) {
            return null;
        }
        return X509Crl.parseDerEncoded(crlFile.getContent(), validationResult);
    }

    private void checkTrustAnchor() {
        if (this.trustAnchors != null && this.trustAnchors.size() > 0) {
            this.result.rejectIfFalse(this.trustAnchors.contains(this.certificates.get(0).getCertificate()), "cert.root.is.ta");
        }
    }

    private class CertificateWithLocation {
        private final X509ResourceCertificate certificate;
        private final ValidationLocation location;

        public CertificateWithLocation(X509ResourceCertificate certificate, ValidationLocation location) {
            this.location = location;
            this.certificate = certificate;
        }

        public X509ResourceCertificate getCertificate() {
            return this.certificate;
        }

        public ValidationLocation getLocation() {
            return this.location;
        }
    }
}

