/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509ResourceCertificateParser
extends X509CertificateParser<X509ResourceCertificate> {
    private static final Pattern PRINTABLE_STRING = Pattern.compile("[-A-Za-z0-9 '()+,./:=?]+");

    @Override
    public X509ResourceCertificate getCertificate() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Resource Certificate validation failed");
        }
        return new X509ResourceCertificate(this.getX509Certificate());
    }

    @Override
    protected void doTypeSpecificValidation() {
        this.validateIssuerAndSubjectDN();
        this.validateCertificatePolicy();
        this.validateResourceExtensions();
        this.validateCrlDistributionPoints();
    }

    private void validateIssuerAndSubjectDN() {
        X500Name issuer = X500Name.getInstance((Object)this.certificate.getIssuerX500Principal().getEncoded());
        this.getValidationResult().warnIfFalse(this.isValidName(issuer), "cert.issuer.correct", this.certificate.getIssuerX500Principal().toString());
        X500Name subject = X500Name.getInstance((Object)this.certificate.getSubjectX500Principal().getEncoded());
        this.getValidationResult().warnIfFalse(this.isValidName(subject), "cert.subject.correct", this.certificate.getSubjectX500Principal().toString());
    }

    private boolean isValidName(X500Name principal) {
        return this.hasOneValidCn(principal) && this.mayHaveOneValidSerialNumber(principal);
    }

    public boolean mayHaveOneValidSerialNumber(X500Name principal) {
        RDN[] serialNumbers = principal.getRDNs(BCStyle.SERIALNUMBER);
        return serialNumbers.length <= 1;
    }

    private boolean hasOneValidCn(X500Name principal) {
        RDN[] cns = principal.getRDNs(BCStyle.CN);
        if (cns.length != 1) {
            return false;
        }
        AttributeTypeAndValue firstCn = cns[0].getFirst();
        if (firstCn == null) {
            return false;
        }
        ASN1Encodable firstCnValue = firstCn.getValue();
        return firstCnValue != null && this.isPrintableString(firstCnValue);
    }

    private boolean isPrintableString(ASN1Encodable value) {
        return value instanceof DERPrintableString;
    }

    private void validateCertificatePolicy() {
        Set<String> criticalExtensionOIDs = this.certificate.getCriticalExtensionOIDs();
        if (!this.result.rejectIfNull(criticalExtensionOIDs, "cert.critical.exts.present")) {
            return;
        }
        this.result.rejectIfFalse(criticalExtensionOIDs.contains(Extension.certificatePolicies.getId()), "cert.policy.ext.critical");
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(Extension.certificatePolicies.getId());
            if (!this.result.rejectIfNull(extensionValue, "cert.policy.ext.value")) {
                return;
            }
            ASN1Sequence policies = ASN1Sequence.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue));
            if (!this.result.rejectIfFalse(policies.size() == 1, "cert.single.cert.policy")) {
                return;
            }
            PolicyInformation policy = PolicyInformation.getInstance((Object)policies.getObjectAt(0));
            if (!this.result.rejectIfNull(policy.getPolicyIdentifier(), "cert.policy.id.present")) {
                return;
            }
            this.result.rejectIfFalse(AbstractX509CertificateWrapper.POLICY_OID.equals((ASN1Primitive)policy.getPolicyIdentifier()), "cert.policy.id.version");
        }
        catch (IOException e) {
            this.result.rejectIfFalse(false, "cert.policy.validation");
        }
    }

    private void validateResourceExtensions() {
        if (this.result.rejectIfFalse(this.isResourceExtensionPresent(), "cert.resource.ext.present")) {
            this.result.rejectIfTrue(false, "cert.as.or.ip.resource.present");
        }
    }

    private void validateCrlDistributionPoints() {
        CRLDistPoint crlDistPoint;
        byte[] extensionValue = this.certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (X509CertificateUtil.isRoot(this.certificate)) {
            this.result.warnIfNotNull(extensionValue, "cert.crldp.omitted");
            return;
        }
        if (!this.result.rejectIfNull(extensionValue, "cert.crldp.present")) {
            return;
        }
        try {
            crlDistPoint = CRLDistPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue));
            this.result.pass("cert.crldp.ext.parsed");
        }
        catch (IOException e) {
            this.result.error("cert.crldp.ext.parsed");
            return;
        }
        this.testCrlDistributionPointsToUrisConversion(crlDistPoint);
        if (!this.result.hasFailureForCurrentLocation()) {
            this.result.rejectIfNull(X509CertificateUtil.findFirstRsyncCrlDistributionPoint(this.certificate), "cert.crldp.rsync.uri.present");
        }
    }

    private void testCrlDistributionPointsToUrisConversion(CRLDistPoint crldp) {
        for (DistributionPoint dp : crldp.getDistributionPoints()) {
            this.result.rejectIfNotNull(dp.getCRLIssuer(), "cert.crldp.issuer.omitted");
            this.result.rejectIfNotNull(dp.getReasons(), "cert.crldp.reasons.omitted");
            if (!this.result.rejectIfNull(dp.getDistributionPoint(), "cert.crldp.present")) {
                return;
            }
            if (!this.result.rejectIfFalse(dp.getDistributionPoint().getType() == 0, "cert.crldp.type.full.name")) {
                return;
            }
            GeneralNames names = (GeneralNames)dp.getDistributionPoint().getName();
            for (GeneralName name : names.getNames()) {
                if (!this.result.rejectIfFalse(name.getTagNo() == 6, "cert.crldp.name.is.a.uri")) {
                    return;
                }
                DERIA5String uri = (DERIA5String)name.getName();
                try {
                    URI.create(uri.getString());
                }
                catch (IllegalArgumentException e) {
                    this.result.error("cert.crldp.uri.syntax");
                    return;
                }
            }
        }
    }
}

