/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsBuilder;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsParser;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GhostbustersCmsParserTest {
    private static final X500Principal TEST_DN = new X500Principal("CN=issuer");
    private static final KeyPair TEST_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
    private static final URI TEST_ROA_LOCATION = URI.create("rsync://certificate/repository/filename.roa");
    private static final URI TEST_CA_LOCATION = URI.create("rsync://certificate/repository/ca.cer");
    private static final URI CRL_DP = URI.create("rsync://certificate/repository/filename.crl");
    private static final BigInteger ROA_CERT_SERIAL = BigInteger.TEN;

    @Ignore(value="This GBR actually does not conform to the RFC")
    @Test
    public void testShouldParseGoodGbr() throws Exception {
        String path = "src/test/resources/conformance/root/goodRealGbrNothingIsWrong.gbr";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(path));
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        parser.parse(ValidationResult.withLocation((String)"test1.gbr"), bytes);
        GhostbustersCms ghostbustersCms = parser.getGhostbustersCms();
        String vCard = ghostbustersCms.getVCardContent();
        Assert.assertEquals((Object)"BEGIN:VCARD\r\nVERSION:3.0\r\nADR:;;5147 Crystal Springs Drive NE;Bainbridge Island;Washington;98110;Uni\r\n ted States\r\nEMAIL:randy@psg.com\r\nFN:Randy Bush\r\nN:;;;;\r\nORG:RGnet\\, LLC\r\nTEL:+1 206 356 8341\r\nEND:VCARD\r\n", (Object)vCard);
    }

    @Test
    public void ghostbusters_record_must_have_vcard() {
        ValidationResult validationResult = this.validatePayload("");
        Assert.assertTrue((boolean)validationResult.hasFailures());
        ValidationCheck check = (ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next();
        Assert.assertEquals((Object)"ghostbusters.record.single.vcard", (Object)check.getKey());
    }

    @Test
    public void ghostbusters_record_must_have_single_vcard() {
        ValidationResult validationResult = this.validatePayload("BEGIN:VCARD\r\nEND:VCARD\r\nBEGIN:VCARD\nEND:VCARD\n");
        Assert.assertTrue((boolean)validationResult.hasFailures());
        ValidationCheck check = (ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next();
        Assert.assertEquals((Object)"ghostbusters.record.single.vcard", (Object)check.getKey());
    }

    private ValidationResult validatePayload(String vCardPayload) {
        byte[] ghostbustersCms = new GhostbustersCmsBuilder().withCertificate(GhostbustersCmsParserTest.createCertificate()).withVCardPayload(vCardPayload).withSignatureProvider("SunRsaSign").getEncoded(TEST_KEY_PAIR.getPrivate());
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        ValidationResult validationResult = ValidationResult.withLocation((String)"test2.gbr");
        parser.parse(validationResult, ghostbustersCms);
        return validationResult;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testShouldParseBadGbr() throws Exception {
        String path = "src/test/resources/conformance/root/badGBRNotVCard.gbr";
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(path));
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        parser.parse(ValidationResult.withLocation((String)"test2.gbr"), bytes);
        parser.getGhostbustersCms().getVCardContent();
    }

    private static X509ResourceCertificate createCertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withIssuerDN(TEST_DN).withSubjectDN(TEST_DN).withSerial(ROA_CERT_SERIAL);
        builder.withPublicKey(TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now.minusMinutes(1), (ReadableInstant)now.plusYears(1)));
        builder.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
        builder.withCrlDistributionPoints(new URI[]{CRL_DP});
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_SIGNED_OBJECT, TEST_ROA_LOCATION)});
        builder.withAuthorityInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, TEST_CA_LOCATION)});
        return builder.build();
    }
}

