/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import org.joda.time.Duration;

public class ValidationOptions {
    private boolean strictManifestCRLValidityChecks = false;
    private Duration crlMaxStalePeriod = Duration.ZERO;
    private Duration manifestMaxStalePeriod = Duration.ZERO;
    private boolean allowOverclaimParentChild = false;

    public ValidationOptions() {
    }

    private ValidationOptions(Boolean strictManifestCRLValidityChecks, Duration crlMaxStalePeriod, Duration manifestMaxStalePeriod) {
        this.strictManifestCRLValidityChecks = strictManifestCRLValidityChecks;
        this.crlMaxStalePeriod = crlMaxStalePeriod;
        this.manifestMaxStalePeriod = manifestMaxStalePeriod;
    }

    public static ValidationOptions strictValidations() {
        return new ValidationOptions(true, Duration.standardHours((long)-7L), Duration.standardHours((long)-7L));
    }

    public static ValidationOptions defaultRipeNccValidator() {
        return new ValidationOptions();
    }

    public static ValidationOptions withStaleConfigurations(Duration maxCrlStalePeriod, Duration maxMftStalePeriod) {
        return new ValidationOptions(true, maxCrlStalePeriod, maxMftStalePeriod);
    }

    public Duration getCrlMaxStalePeriod() {
        return this.crlMaxStalePeriod;
    }

    public Duration getManifestMaxStalePeriod() {
        return this.manifestMaxStalePeriod;
    }

    public boolean isAllowOverclaimParentChild() {
        return this.allowOverclaimParentChild;
    }

    public void setAllowOverclaimParentChild(boolean allowOverclaimParentChild) {
        this.allowOverclaimParentChild = allowOverclaimParentChild;
    }

    public boolean isStrictManifestCRLValidityChecks() {
        return this.strictManifestCRLValidityChecks;
    }

    public void setStrictManifestCRLValidityChecks(boolean strictManifestCRLValidityChecks) {
        this.strictManifestCRLValidityChecks = strictManifestCRLValidityChecks;
    }
}

