/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509.pkcs10;

import java.io.IOException;
import java.net.URI;
import java.security.PublicKey;
import java.util.Enumeration;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.provisioning.x509.pkcs10.RpkiCaCertificateRequestParserException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

public class RpkiCaCertificateRequestParser {
    private static final String DEFAULT_SIGNATURE_PROVIDER = "SunRsaSign";
    private JcaPKCS10CertificationRequest pkcs10CertificationRequest;
    private URI caRepositoryUri;
    private URI manifestUri;
    private URI notificationUri;
    private PublicKey publicKey;

    public RpkiCaCertificateRequestParser(PKCS10CertificationRequest pkcs10CertificationRequest) throws RpkiCaCertificateRequestParserException {
        this.pkcs10CertificationRequest = new JcaPKCS10CertificationRequest(pkcs10CertificationRequest);
        this.process();
        if (this.caRepositoryUri == null) {
            throw new RpkiCaCertificateRequestParserException("No CA Repository URI included in SIA in request");
        }
        if (this.manifestUri == null) {
            throw new RpkiCaCertificateRequestParserException("No Manifest URI included in SIA in request");
        }
        if (this.publicKey == null) {
            throw new RpkiCaCertificateRequestParserException("No Public Key included in request");
        }
    }

    public URI getCaRepositoryUri() {
        return this.caRepositoryUri;
    }

    public URI getManifestUri() {
        return this.manifestUri;
    }

    public URI getNotificationUri() {
        return this.notificationUri;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    private void process() throws RpkiCaCertificateRequestParserException {
        this.extractPublicKey();
        this.extractSiaUris();
        this.verifyRequest();
    }

    private void extractPublicKey() throws RpkiCaCertificateRequestParserException {
        try {
            this.publicKey = this.pkcs10CertificationRequest.getPublicKey();
        }
        catch (Exception e) {
            throw new RpkiCaCertificateRequestParserException(e);
        }
    }

    private void extractSiaUris() throws RpkiCaCertificateRequestParserException {
        try {
            Extensions extensions = this.getPkcs9Extensions();
            Extension extension = extensions.getExtension(Extension.subjectInfoAccess);
            ASN1Sequence accessDescriptorSequence = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])extension.getExtnValue().getOctets());
            Enumeration objects = accessDescriptorSequence.getObjects();
            while (objects.hasMoreElements()) {
                AccessDescription accessDescription = AccessDescription.getInstance(objects.nextElement());
                X509CertificateInformationAccessDescriptor accessDescriptor = new X509CertificateInformationAccessDescriptor(accessDescription);
                ASN1ObjectIdentifier oid = accessDescriptor.getMethod();
                if (oid.equals((Object)X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY)) {
                    this.caRepositoryUri = accessDescriptor.getLocation();
                    continue;
                }
                if (oid.equals((Object)X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST)) {
                    this.manifestUri = accessDescriptor.getLocation();
                    continue;
                }
                if (oid.equals((Object)X509CertificateInformationAccessDescriptor.ID_AD_RPKI_NOTIFY)) {
                    this.notificationUri = accessDescriptor.getLocation();
                    continue;
                }
                throw new RpkiCaCertificateRequestParserException("Don't understand access descriptor using method: " + oid);
            }
        }
        catch (IOException e) {
            throw new RpkiCaCertificateRequestParserException(e);
        }
    }

    private Extensions getPkcs9Extensions() throws RpkiCaCertificateRequestParserException {
        ASN1Set pkcs9ExtensionRequest = this.getPkcs9ExtensionRequest();
        Object extensionRequestElement = pkcs9ExtensionRequest.getObjects().nextElement();
        if (extensionRequestElement instanceof Extensions) {
            return (Extensions)extensionRequestElement;
        }
        if (extensionRequestElement instanceof ASN1Sequence) {
            return Extensions.getInstance((Object)((ASN1Sequence)extensionRequestElement));
        }
        throw new RpkiCaCertificateRequestParserException("Encountered an element I do not understand, type: " + extensionRequestElement.getClass().getSimpleName());
    }

    private ASN1Set getPkcs9ExtensionRequest() throws RpkiCaCertificateRequestParserException {
        Attribute[] attributes;
        for (Attribute attr : attributes = this.pkcs10CertificationRequest.getAttributes()) {
            ASN1ObjectIdentifier oid = attr.getAttrType();
            if (!oid.equals((Object)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
            return attr.getAttrValues();
        }
        throw new RpkiCaCertificateRequestParserException("Could not find PKCS 9 Extension Request");
    }

    private void verifyRequest() throws RpkiCaCertificateRequestParserException {
        try {
            ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider(DEFAULT_SIGNATURE_PROVIDER).build(this.publicKey);
            if (!this.pkcs10CertificationRequest.isSignatureValid(contentVerifierProvider)) {
                throw new RpkiCaCertificateRequestParserException("signature validation failed");
            }
        }
        catch (OperatorCreationException e) {
            throw new RpkiCaCertificateRequestParserException("Could not verify request", (Exception)((Object)e));
        }
        catch (PKCSException e) {
            throw new RpkiCaCertificateRequestParserException("Could not verify request", (Exception)((Object)e));
        }
    }
}

