/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import java.net.URI;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.ResourceClassUtil;
import org.apache.commons.lang.Validate;

public class CertificateElementBuilder {
    private List<URI> certificatePublishedLocations;
    private IpResourceSet ipResourceSet;
    private X509ResourceCertificate certificate;

    public CertificateElementBuilder withCertificatePublishedLocations(List<URI> uris) {
        this.certificatePublishedLocations = uris;
        return this;
    }

    public CertificateElementBuilder withIpResources(IpResourceSet ipResourceSet) {
        this.ipResourceSet = ipResourceSet;
        return this;
    }

    public CertificateElementBuilder withCertificate(X509ResourceCertificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public CertificateElement build() {
        boolean rsyncUriFound = ResourceClassUtil.hasRsyncUri(this.certificatePublishedLocations);
        Validate.isTrue((boolean)rsyncUriFound, (String)"No RSYNC URI provided");
        Validate.notNull((Object)this.certificate, (String)"No certificate provided");
        return new CertificateElement().setIssuerCertificatePublicationLocation(this.certificatePublishedLocations).setIpResourceSet(this.ipResourceSet).setCertificate(this.certificate);
    }
}

