/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.crl;

import java.security.SignatureException;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class X509CrlValidator
implements CertificateRepositoryObjectValidator<X509Crl> {
    private AbstractX509CertificateWrapper parent;
    private ValidationOptions options;
    private ValidationResult result;

    public X509CrlValidator(ValidationOptions options, ValidationResult result, AbstractX509CertificateWrapper parent) {
        this.options = options;
        this.result = result;
        this.parent = parent;
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.result;
    }

    @Override
    public void validate(String location, X509Crl crl) {
        this.result.setLocation(new ValidationLocation(location));
        this.checkSignature(crl);
        this.checkValidityTimes(crl);
    }

    private void checkValidityTimes(X509Crl crl) {
        DateTime now = UTC.dateTime();
        DateTime nextUpdateTime = crl.getNextUpdateTime();
        DateTime thisUpdateTime = crl.getThisUpdateTime();
        this.result.rejectIfTrue(thisUpdateTime.isAfter((ReadableInstant)now), "crl.this.update.after.now", thisUpdateTime.toString());
        if (this.options.isStrictManifestCRLValidityChecks()) {
            boolean postGracePeriod = now.isAfter((ReadableInstant)nextUpdateTime.plus((ReadableDuration)this.options.getCrlMaxStalePeriod()));
            if (postGracePeriod) {
                this.result.error("crl.next.update.before.now", nextUpdateTime.toString());
            } else {
                this.result.warnIfTrue(now.isAfter((ReadableInstant)nextUpdateTime), "crl.next.update.before.now", nextUpdateTime.toString());
            }
        } else {
            this.result.warnIfTrue(now.isAfter((ReadableInstant)nextUpdateTime), "crl.next.update.before.now", nextUpdateTime.toString());
        }
    }

    private void checkSignature(X509Crl crl) {
        boolean signatureValid;
        try {
            crl.verify(this.parent.getPublicKey());
            signatureValid = true;
        }
        catch (SignatureException e) {
            signatureValid = false;
        }
        this.result.rejectIfFalse(signatureValid, "cert.crl.signature", new String[0]);
    }
}

