/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificate;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ProvisioningCmsCertificateBuilder {
    private static final int DEFAULT_VALIDITY_TIME_DAYS_FROM_NOW = 1;
    private X509CertificateBuilderHelper builderHelper = new X509CertificateBuilderHelper();

    public ProvisioningCmsCertificateBuilder withSignatureProvider(String signatureProvider) {
        this.builderHelper.withSignatureProvider(signatureProvider);
        return this;
    }

    public ProvisioningCmsCertificateBuilder withSerial(BigInteger serial) {
        this.builderHelper.withSerial(serial);
        return this;
    }

    public ProvisioningCmsCertificateBuilder withSubjectDN(X500Principal subjectDN) {
        this.builderHelper.withSubjectDN(subjectDN);
        return this;
    }

    public ProvisioningCmsCertificateBuilder withIssuerDN(X500Principal issuerDN) {
        this.builderHelper.withIssuerDN(issuerDN);
        return this;
    }

    public ProvisioningCmsCertificateBuilder withPublicKey(PublicKey publicKey) {
        this.builderHelper.withPublicKey(publicKey);
        return this;
    }

    public ProvisioningCmsCertificateBuilder withSigningKeyPair(KeyPair signingKey) {
        this.builderHelper.withSigningKeyPair(signingKey);
        return this;
    }

    public ProvisioningCmsCertificate build() {
        this.setUpImplicitRequirementsForBuilderHelper();
        return new ProvisioningCmsCertificate(this.builderHelper.generateCertificate());
    }

    private void setUpImplicitRequirementsForBuilderHelper() {
        this.builderHelper.withCa(false);
        this.builderHelper.withKeyUsage(128);
        this.builderHelper.withAuthorityKeyIdentifier(true);
        this.builderHelper.withSubjectKeyIdentifier(true);
        DateTime now = UTC.dateTime();
        this.builderHelper.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)now.plusDays(1)));
    }
}

