/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload;

import com.google.common.io.Closer;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectBuilderException;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;

class ProvisioningPayloadXmlSerializer<T extends AbstractProvisioningPayload>
extends XStreamXmlSerializer<T> {
    public ProvisioningPayloadXmlSerializer(XStream xStream, Class<T> objectType) {
        super(xStream, objectType);
    }

    @Override
    public String serialize(T object) {
        try {
            return this.serializeUTF8Encoded(object);
        }
        catch (IOException e) {
            throw new ProvisioningCmsObjectBuilderException(e);
        }
    }

    private String serializeUTF8Encoded(T payload) throws IOException {
        String xml;
        try (Closer closer = Closer.create();){
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closer.register((Closeable)new ByteArrayOutputStream());
            Writer writer = (Writer)closer.register((Closeable)new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.getProperty("line.separator"));
            super.serialize(payload, writer);
            String rawXml = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            xml = rawXml.replace("<message", "<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\"");
        }
        return xml;
    }
}

