/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.StringUtils;

public class GhostbustersCmsParser
extends RpkiSignedObjectParser {
    private String vCardPayload;

    @Override
    public void parse(ValidationResult result, byte[] encoded) {
        super.parse(result, encoded);
        this.validateGhostbusters();
    }

    @Override
    public void decodeRawContent(InputStream content) throws IOException {
        this.vCardPayload = CharStreams.toString((Readable)new InputStreamReader(content, StandardCharsets.UTF_8));
    }

    protected void validateGhostbusters() {
        ValidationResult validationResult = this.getValidationResult();
        if (!validationResult.rejectIfFalse(this.getContentType() != null, "ghostbusters.record.content.type", new String[0])) {
            return;
        }
        if (!validationResult.rejectIfFalse(GhostbustersCms.CONTENT_TYPE.equals((Object)this.getContentType()), "ghostbusters.record.content.type", this.getContentType().toString())) {
            return;
        }
        if (!validationResult.rejectIfFalse(StringUtils.isNotBlank((String)this.vCardPayload), "ghostbusters.record.single.vcard", new String[0])) {
            return;
        }
        if (!validationResult.rejectIfFalse(this.vCardPayload.startsWith("BEGIN:VCARD") && StringUtils.countMatches((String)this.vCardPayload, (String)"BEGIN:VCARD") == 1, "ghostbusters.record.single.vcard", new String[0])) {
            return;
        }
        if (!validationResult.rejectIfFalse(StringUtils.trim((String)this.vCardPayload).endsWith("END:VCARD") && StringUtils.countMatches((String)this.vCardPayload, (String)"END:VCARD") == 1, "ghostbusters.record.single.vcard", new String[0])) {
            return;
        }
    }

    public GhostbustersCms getGhostbustersCms() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Ghostbuster record validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        return new GhostbustersCms(cmsObjectData, this.vCardPayload);
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailureForCurrentLocation();
    }
}

