/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificateTest;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class X509ResourceCertificateParserTest {
    private X509ResourceCertificateParser subject = new X509ResourceCertificateParser();

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireResourceCertificatePolicy() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withPolicies(new PolicyInformation[0]);
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        this.subject.getCertificate();
    }

    @Test
    public void shouldParseResourceCertificateWhenResourceExtensionsArePresent() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        X509ResourceCertificate parsed = this.subject.getCertificate();
        Assert.assertEquals((Object)certificate, (Object)parsed);
    }

    @Test
    public void shouldFailOnInvalidInput() {
        byte[] badlyEncoded = new byte[]{1, 3, 35};
        this.subject.parse("badly", badlyEncoded);
        Assert.assertTrue((boolean)this.subject.getValidationResult().getFailures(new ValidationLocation("badly")).contains(new ValidationCheck(ValidationStatus.ERROR, "cert.parsed", new String[0])));
    }

    @Test
    public void shouldFailOnInvalidSignatureAlgorithm() throws CertificateEncodingException {
        X509CertificateBuilderHelper builder = new X509CertificateBuilderHelper();
        builder.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        builder.withSerial(BigInteger.ONE);
        builder.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = UTC.dateTime();
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        builder.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
        builder.withSignatureAlgorithm("MD5withRSA");
        X509Certificate certificate = builder.generateCertificate();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().hasFailures());
        Assert.assertFalse((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.signature.algorithm").isOk());
    }

    @Test
    public void should_validate_key_algorithm_and_size() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        this.subject.parse("certificate", certificate.getEncoded());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.algorithm").isOk());
        Assert.assertTrue((boolean)this.subject.getValidationResult().getResult(new ValidationLocation("certificate"), "cert.public.key.size").isOk());
    }

    @Test
    public void should_parse_resource_certificate_when_its_unknown() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder();
        X509ResourceCertificate certificate = builder.build();
        ValidationResult result = ValidationResult.withLocation((String)"test");
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertTrue((boolean)(certificateWrapper instanceof X509ResourceCertificate));
        X509ResourceCertificate parsed = (X509ResourceCertificate)certificateWrapper;
        Assert.assertEquals((Object)parsed.getPublicKey(), (Object)certificate.getPublicKey());
        Assert.assertEquals((Object)parsed.getResources(), (Object)certificate.getResources());
    }

    @Test
    public void should_parse_router_certificate_when_its_unknown() {
        X509RouterCertificateBuilder builder = X509RouterCertificateTest.createSelfSignedRouterCertificateBuilder().withAsns(new int[]{1, 2, 3});
        X509RouterCertificate certificate = builder.build();
        ValidationResult result = ValidationResult.withLocation((String)"test");
        X509GenericCertificate certificateWrapper = X509ResourceCertificateParser.parseCertificate((ValidationResult)result, (byte[])certificate.getEncoded());
        Assert.assertTrue((boolean)(certificateWrapper instanceof X509RouterCertificate));
        X509RouterCertificate parsed = (X509RouterCertificate)certificateWrapper;
        Assert.assertEquals((Object)parsed.getPublicKey(), (Object)certificate.getPublicKey());
    }
}

