/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.util.UTC;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public final class PregeneratedKeyPairFactory
extends KeyPairFactory {
    private static final PregeneratedKeyPairFactory INSTANCE = new PregeneratedKeyPairFactory("SunRsaSign");
    private static final char[] PASSPHRASE = "passphrase".toCharArray();
    private File keyStoreFile = new File(".pregenerated-test-key-pairs.keystore");
    private KeyStore pregeneratedKeys;
    private int count = 0;

    private PregeneratedKeyPairFactory(String provider) {
        super(provider);
        this.initKeyStore();
    }

    private void initKeyStore() {
        try (Closer closer = Closer.create();){
            InputStream input;
            try {
                input = (InputStream)closer.register((Closeable)new FileInputStream(this.keyStoreFile));
            }
            catch (FileNotFoundException e) {
                input = null;
            }
            this.pregeneratedKeys = KeyStore.getInstance("JKS", "SUN");
            this.pregeneratedKeys.load(input, PASSPHRASE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PregeneratedKeyPairFactory getInstance() {
        return INSTANCE;
    }

    public KeyPairFactory withProvider(String provider) {
        return this;
    }

    public synchronized KeyPair generate() {
        try {
            KeyPair result;
            String alias = "key_" + this.count;
            ++this.count;
            PrivateKey key = (PrivateKey)this.pregeneratedKeys.getKey(alias, PASSPHRASE);
            if (key == null) {
                result = super.generate();
                this.pregeneratedKeys.setKeyEntry(alias, result.getPrivate(), PASSPHRASE, new Certificate[]{PregeneratedKeyPairFactory.createCertificate(result).getCertificate()});
                try (Closer closer = Closer.create();){
                    FileOutputStream output = new FileOutputStream(this.keyStoreFile);
                    this.pregeneratedKeys.store(output, PASSPHRASE);
                }
            } else {
                Certificate certificate = this.pregeneratedKeys.getCertificateChain(alias)[0];
                result = new KeyPair(certificate.getPublicKey(), key);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static X509ResourceCertificate createCertificate(KeyPair keyPair) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSignatureProvider("SunRsaSign");
        builder.withSerial(BigInteger.ONE);
        DateTime now = UTC.dateTime();
        builder.withValidityPeriod(new ValidityPeriod((ReadableInstant)now.minusYears(2), (ReadableInstant)now.minusYears(1)));
        builder.withCa(false);
        builder.withIssuerDN(new X500Principal("CN=issuer"));
        builder.withSubjectDN(new X500Principal("CN=subject"));
        builder.withResources(IpResourceSet.parse((String)"AS1-AS10,10/8,ffc0::/16"));
        builder.withSigningKeyPair(keyPair);
        builder.withPublicKey(keyPair.getPublic());
        return builder.build();
    }
}

