/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.X509ResourceCertificateBase64Converter;
import net.ripe.rpki.commons.provisioning.serialization.CertificateUrlListConverter;
import net.ripe.rpki.commons.provisioning.serialization.IpResourceSetProvisioningConverter;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;

public class GenericClassElement {
    @XStreamAsAttribute
    @XStreamAlias(value="class_name")
    private String className;
    @XStreamAlias(value="cert_url")
    @XStreamAsAttribute
    @XStreamConverter(value=CertificateUrlListConverter.class)
    private List<URI> certificateAuthorityUri;
    @XStreamAlias(value="resource_set_as")
    @XStreamAsAttribute
    @XStreamConverter(value=IpResourceSetProvisioningConverter.class)
    private IpResourceSet resourceSetAs = new IpResourceSet();
    @XStreamAlias(value="resource_set_ipv4")
    @XStreamAsAttribute
    @XStreamConverter(value=IpResourceSetProvisioningConverter.class)
    private IpResourceSet resourceSetIpv4 = new IpResourceSet();
    @XStreamAlias(value="resource_set_ipv6")
    @XStreamAsAttribute
    @XStreamConverter(value=IpResourceSetProvisioningConverter.class)
    private IpResourceSet resourceSetIpv6 = new IpResourceSet();
    @XStreamAlias(value="certificate")
    @XStreamImplicit(itemFieldName="certificate")
    private List<CertificateElement> certificateElements = new ArrayList<CertificateElement>();
    @XStreamConverter(value=X509ResourceCertificateBase64Converter.class)
    @XStreamAlias(value="issuer")
    private X509ResourceCertificate issuer;
    @XStreamAlias(value="resource_set_notafter")
    @XStreamAsAttribute
    private DateTime validityNotAfter;
    @XStreamAlias(value="suggested_sia_head")
    @XStreamAsAttribute
    private String siaHeadUri;

    public DateTime getValidityNotAfter() {
        return this.validityNotAfter;
    }

    public void setValidityNotAfter(DateTime validityNotAfter) {
        this.validityNotAfter = validityNotAfter;
    }

    public String getSiaHeadUri() {
        return this.siaHeadUri;
    }

    public void setSiaHeadUri(String siaHeadUri) {
        this.siaHeadUri = siaHeadUri;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<URI> getCertificateAuthorityUri() {
        return this.certificateAuthorityUri;
    }

    public void setCertUris(List<URI> certUris) {
        this.certificateAuthorityUri = certUris;
    }

    public IpResourceSet getResourceSetAsn() {
        return this.resourceSetAs;
    }

    public IpResourceSet getResourceSetIpv4() {
        return this.resourceSetIpv4;
    }

    public IpResourceSet getResourceSetIpv6() {
        return this.resourceSetIpv6;
    }

    public void setIpResourceSet(IpResourceSet ipResourceSet) {
        IpResourceSet asns = new IpResourceSet();
        IpResourceSet ipv4 = new IpResourceSet();
        IpResourceSet ipv6 = new IpResourceSet();
        for (IpResource resource : ipResourceSet) {
            switch (resource.getType()) {
                case ASN: {
                    asns.add(resource);
                    break;
                }
                case IPv4: {
                    ipv4.add(resource);
                    break;
                }
                case IPv6: {
                    ipv6.add(resource);
                }
            }
        }
        this.resourceSetAs = asns;
        this.resourceSetIpv4 = ipv4;
        this.resourceSetIpv6 = ipv6;
    }

    public X509ResourceCertificate getIssuer() {
        return this.issuer;
    }

    public void setIssuer(X509ResourceCertificate issuer) {
        this.issuer = issuer;
    }

    protected List<CertificateElement> getCertificateElements() {
        return this.certificateElements;
    }

    protected void setCertificateElements(List<CertificateElement> certificateElements) {
        this.certificateElements = certificateElements;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

