/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapperException;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.PolicyInformation;

public abstract class AbstractX509CertificateWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ASN1ObjectIdentifier POLICY_OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.14.2");
    public static final PolicyInformation POLICY_INFORMATION = new PolicyInformation(POLICY_OID);
    private final X509Certificate certificate;

    protected AbstractX509CertificateWrapper(X509Certificate certificate) {
        Validate.notNull((Object)certificate);
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] getEncoded() {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }

    public ASN1ObjectIdentifier getCertificatePolicy() {
        return POLICY_OID;
    }

    public int hashCode() {
        return this.certificate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractX509CertificateWrapper)) {
            return false;
        }
        AbstractX509CertificateWrapper other = (AbstractX509CertificateWrapper)obj;
        return this.certificate.equals(other.certificate);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("serial", (Object)this.getSerialNumber()).append("subject", (Object)this.getSubject()).toString();
    }

    public boolean isEe() {
        return X509CertificateUtil.isEe(this.certificate);
    }

    public boolean isCa() {
        return X509CertificateUtil.isCa(this.certificate);
    }

    public boolean isRoot() {
        return X509CertificateUtil.isRoot(this.certificate);
    }

    public URI getManifestUri() {
        return X509CertificateUtil.getManifestUri(this.certificate);
    }

    public URI getRepositoryUri() {
        return X509CertificateUtil.getRepositoryUri(this.certificate);
    }

    public URI getRrdpNotifyUri() {
        return X509CertificateUtil.getRrdpNotifyUri(this.certificate);
    }

    public boolean isObjectIssuer() {
        return X509CertificateUtil.isObjectIssuer(this.certificate);
    }

    public byte[] getSubjectKeyIdentifier() {
        return X509CertificateUtil.getSubjectKeyIdentifier(this.certificate);
    }

    public byte[] getAuthorityKeyIdentifier() {
        return X509CertificateUtil.getAuthorityKeyIdentifier(this.certificate);
    }

    public X500Principal getSubject() {
        return X509CertificateUtil.getSubject(this.certificate);
    }

    public X500Principal getIssuer() {
        return X509CertificateUtil.getIssuer(this.certificate);
    }

    public PublicKey getPublicKey() {
        return X509CertificateUtil.getPublicKey(this.certificate);
    }

    public ValidityPeriod getValidityPeriod() {
        return X509CertificateUtil.getValidityPeriod(this.certificate);
    }

    public BigInteger getSerialNumber() {
        return X509CertificateUtil.getSerialNumber(this.certificate);
    }

    public X509CertificateInformationAccessDescriptor[] getAuthorityInformationAccess() {
        return X509CertificateUtil.getAuthorityInformationAccess(this.certificate);
    }

    public URI findFirstAuthorityInformationAccessByMethod(ASN1ObjectIdentifier method) {
        return X509CertificateUtil.findFirstAuthorityInformationAccessByMethod(this.certificate, method);
    }

    public X509CertificateInformationAccessDescriptor[] getSubjectInformationAccess() {
        return X509CertificateUtil.getSubjectInformationAccess(this.certificate);
    }

    public URI findFirstSubjectInformationAccessByMethod(ASN1ObjectIdentifier method) {
        return X509CertificateUtil.findFirstSubjectInformationAccessByMethod(this.certificate, method);
    }

    public URI[] getCrlDistributionPoints() {
        return X509CertificateUtil.getCrlDistributionPoints(this.certificate);
    }

    public URI findFirstRsyncCrlDistributionPoint() {
        return X509CertificateUtil.findFirstRsyncCrlDistributionPoint(this.certificate);
    }

    public void verify(PublicKey publicKey) throws InvalidKeyException, SignatureException {
        X509CertificateUtil.verify(this.certificate, publicKey);
    }
}

