/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.junit.Before;
import org.junit.Test;

public class X509CertificateBuilderHelperTest {
    private X509CertificateBuilderHelper subject;

    @Before
    public void setUp() {
        this.subject = new X509CertificateBuilderHelper();
        this.subject.withSubjectDN(new X500Principal("CN=zz.subject")).withIssuerDN(new X500Principal("CN=zz.issuer"));
        this.subject.withSerial(BigInteger.ONE);
        this.subject.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        this.subject.withSigningKeyPair(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR);
        DateTime now = new DateTime(DateTimeZone.UTC);
        this.subject.withValidityPeriod(new ValidityPeriod((ReadableInstant)now, (ReadableInstant)new DateTime(now.getYear() + 1, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.subject.withResources(IpResourceSet.ALL_PRIVATE_USE_RESOURCES);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnIncorrectAlgorithm() {
        this.subject.withSignatureAlgorithm("foo");
        this.subject.generateCertificate();
    }
}

