/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.x509;

import java.security.KeyPair;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificateBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningIdentityCertificateBuilderTest {
    private ProvisioningIdentityCertificateBuilder subject;
    public static final X500Principal SELF_SIGNING_DN = new X500Principal("CN=test");
    public static final KeyPair TEST_IDENTITY_KEYPAIR = ProvisioningObjectMother.TEST_KEY_PAIR;
    public static final KeyPair TEST_IDENTITY_KEYPAIR_2 = ProvisioningObjectMother.TEST_KEY_PAIR_2;
    public static final ProvisioningIdentityCertificate TEST_IDENTITY_CERT = ProvisioningIdentityCertificateBuilderTest.getTestProvisioningIdentityCertificate();
    public static final ProvisioningIdentityCertificate TEST_IDENTITY_CERT_2 = ProvisioningIdentityCertificateBuilderTest.getProvisioningIdentityCertificateForKey2();

    private static ProvisioningIdentityCertificate getTestProvisioningIdentityCertificate() {
        return ProvisioningIdentityCertificateBuilderTest.getTestBuilder(TEST_IDENTITY_KEYPAIR).build();
    }

    private static ProvisioningIdentityCertificate getProvisioningIdentityCertificateForKey2() {
        return ProvisioningIdentityCertificateBuilderTest.getTestBuilder(TEST_IDENTITY_KEYPAIR_2).build();
    }

    private static ProvisioningIdentityCertificateBuilder getTestBuilder(KeyPair keyPair) {
        ProvisioningIdentityCertificateBuilder identityCertificateBuilder = new ProvisioningIdentityCertificateBuilder();
        identityCertificateBuilder.withSelfSigningKeyPair(keyPair);
        identityCertificateBuilder.withSelfSigningSubject(SELF_SIGNING_DN);
        return identityCertificateBuilder;
    }

    @Before
    public void setUp() {
        this.subject = ProvisioningIdentityCertificateBuilderTest.getTestBuilder(TEST_IDENTITY_KEYPAIR);
    }

    @Test
    public void shouldBuild() {
        ProvisioningIdentityCertificate identityCert = this.subject.build();
        Assert.assertNotNull((Object)identityCert);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireSelfSigningKeyPair() {
        this.subject = new ProvisioningIdentityCertificateBuilder();
        this.subject.withSelfSigningSubject(SELF_SIGNING_DN);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireSelfSigningDN() {
        this.subject.withSelfSigningSubject(null);
        this.subject.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireSignatureProvider() {
        this.subject.withSignatureProvider(null);
        this.subject.build();
    }

    @Test
    public void shouldUseSHA256withRSA() {
        ProvisioningIdentityCertificate identityCert = this.subject.build();
        Assert.assertEquals((Object)"SHA256withRSA", (Object)identityCert.getCertificate().getSigAlgName());
    }

    @Test
    public void shouldUseProvidedSigningKey() {
        Assert.assertEquals((Object)TEST_IDENTITY_KEYPAIR.getPublic(), (Object)TEST_IDENTITY_CERT.getPublicKey());
    }

    @Test
    public void shouldHaveNoRsyncCrlPointer() {
        Assert.assertNull((Object)TEST_IDENTITY_CERT.findFirstRsyncCrlDistributionPoint());
    }

    @Test
    public void shouldNotHaveAiaPointer() {
        Assert.assertNull((Object)TEST_IDENTITY_CERT.getAuthorityInformationAccess());
    }

    @Test
    public void shouldHaveSiaPointerToDirectoryOnly() {
        Assert.assertNull((Object)TEST_IDENTITY_CERT.getSubjectInformationAccess());
    }

    @Test
    public void shouldBeACACertificate() {
        Assert.assertTrue((boolean)TEST_IDENTITY_CERT.isCa());
    }

    @Test
    public void shouldIncludeKeyUsageBitsCertSignAndCrlCertSign() {
        boolean[] keyUsage = TEST_IDENTITY_CERT.getCertificate().getKeyUsage();
        Assert.assertNotNull((Object)keyUsage);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, false, false, false, false, true, true, false, false}, keyUsage));
    }
}

