/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.serialization;

import java.net.URI;
import java.util.Arrays;
import net.ripe.rpki.commons.provisioning.serialization.CertificateUrlListConverter;
import org.junit.Assert;
import org.junit.Test;

public class CertificateUrlListConverterTest {
    private static final URI URI_WITH_COMMA = URI.create("http://localhost/unescaped,comma");
    private static final URI URI_WITH_ESCAPED_COMMA = URI.create("http://localhost/escaped%2Ccomma");
    private CertificateUrlListConverter subject = new CertificateUrlListConverter();

    @Test
    public void shouldEscapeCommasInUris() {
        Assert.assertEquals((Object)"http://localhost/unescaped%2Ccomma", (Object)this.subject.toString(Arrays.asList(URI_WITH_COMMA)));
    }

    @Test
    public void shouldSeparateUrisWithCommas() {
        Assert.assertEquals((Object)"http://localhost/unescaped%2Ccomma,http://localhost/escaped%2Ccomma", (Object)this.subject.toString(Arrays.asList(URI_WITH_COMMA, URI_WITH_ESCAPED_COMMA)));
    }

    @Test
    public void shouldNotUnescapeCommas() {
        Assert.assertEquals(Arrays.asList(URI.create("http://localhost/unescaped%2Ccomma"), URI_WITH_ESCAPED_COMMA), (Object)this.subject.fromString("http://localhost/unescaped%2Ccomma,http://localhost/escaped%2Ccomma"));
    }
}

