/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.interop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class BBNConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseAllObjects() throws IOException {
        int objectCount = 0;
        int errorCount = 0;
        int exceptionCount = 0;
        Iterator fileIterator = FileUtils.iterateFiles((File)new File(PATH_TO_BBN_OBJECTS), (String[])new String[]{"cer", "crl", "mft", "roa"}, (boolean)true);
        while (fileIterator.hasNext()) {
            ++objectCount;
            File file = (File)fileIterator.next();
            byte[] encoded = Files.toByteArray((File)file);
            ValidationResult result = ValidationResult.withLocation((String)file.getName());
            try {
                if (file.getName().endsWith("cer")) {
                    new X509ResourceCertificateParser().parse(result, encoded);
                } else if (file.getName().endsWith("crl")) {
                    X509Crl.parseDerEncoded((byte[])encoded, (ValidationResult)result);
                } else if (file.getName().endsWith("mft")) {
                    new ManifestCmsParser().parse(result, encoded);
                } else if (file.getName().endsWith("roa")) {
                    new RoaCmsParser().parse(result, encoded);
                }
                if (result.hasFailures() && file.getName().startsWith("good")) {
                    System.err.println("Supposed to be good: " + file.getName());
                    ++errorCount;
                    continue;
                }
                if (!result.hasFailures() && file.getName().startsWith("bad")) {
                    System.err.println("Supposed to be bad: " + file.getName());
                    ++errorCount;
                    continue;
                }
                System.out.println(file.getName() + " -> " + result.hasFailures());
            }
            catch (RuntimeException ex) {
                System.err.println("Exception while parsing " + file.getName());
                ++exceptionCount;
            }
        }
        System.out.println(objectCount + " objects: " + errorCount + " errors, " + exceptionCount + " exceptions");
    }
}

