/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationMetric;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.DateTimeUtils;

public final class ValidationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<ValidationLocation, Map<ValidationStatus, List<ValidationCheck>>> results = new LinkedHashMap<ValidationLocation, Map<ValidationStatus, List<ValidationCheck>>>();
    private ValidationLocation currentLocation;
    private Map<ValidationLocation, List<ValidationMetric>> metrics = new LinkedHashMap<ValidationLocation, List<ValidationMetric>>();

    private ValidationResult(ValidationLocation location) {
        this.setLocation(location);
    }

    public static ValidationResult withLocation(URI uri) {
        return new ValidationResult(new ValidationLocation(uri));
    }

    public static ValidationResult withLocation(String name) {
        return new ValidationResult(new ValidationLocation(name));
    }

    public static ValidationResult withLocation(ValidationLocation location) {
        return new ValidationResult(location);
    }

    public void setLocation(ValidationLocation location) {
        this.currentLocation = location;
        if (!this.results.containsKey(this.currentLocation)) {
            LinkedHashMap locationResults = new LinkedHashMap();
            locationResults.put(ValidationStatus.ERROR, new ArrayList());
            locationResults.put(ValidationStatus.WARNING, new ArrayList());
            locationResults.put(ValidationStatus.PASSED, new ArrayList());
            this.results.put(this.currentLocation, locationResults);
        }
    }

    private void setValidationCheckForCurrentLocation(ValidationStatus status, String key, String ... param) {
        Map<ValidationStatus, List<ValidationCheck>> currentResults = this.results.get(this.currentLocation);
        List<ValidationCheck> checksForStatus = currentResults.get((Object)status);
        checksForStatus.add(new ValidationCheck(status, key, param));
    }

    public void pass(String key, String ... param) {
        this.setValidationCheckForCurrentLocation(ValidationStatus.PASSED, key, param);
    }

    public void warn(String key, String ... param) {
        this.setValidationCheckForCurrentLocation(ValidationStatus.WARNING, key, param);
    }

    public void error(String key, String ... param) {
        this.setValidationCheckForCurrentLocation(ValidationStatus.ERROR, key, param);
    }

    public boolean warnIfFalse(boolean condition, String key, String ... param) {
        Validate.notNull((Object)key, (String)"key is required");
        if (condition) {
            this.setValidationCheckForCurrentLocation(ValidationStatus.PASSED, key, param);
        } else {
            this.warn(key, param);
        }
        return condition;
    }

    public boolean warnIfTrue(boolean condition, String key, String ... param) {
        return this.warnIfFalse(!condition, key, param);
    }

    public boolean warnIfNull(Object object, String key, String ... param) {
        return this.warnIfTrue(object == null, key, param);
    }

    public boolean warnIfNotNull(Object object, String key, String ... param) {
        return this.warnIfTrue(object != null, key, param);
    }

    public void rejectForLocation(ValidationLocation location, String key, String ... param) {
        ValidationLocation locationBefore = this.currentLocation;
        this.setLocation(location);
        this.setValidationCheckForCurrentLocation(ValidationStatus.ERROR, key, param);
        this.setLocation(locationBefore);
    }

    public void warnForLocation(ValidationLocation location, String key, String ... param) {
        ValidationLocation locationBefore = this.currentLocation;
        this.setLocation(location);
        this.setValidationCheckForCurrentLocation(ValidationStatus.WARNING, key, param);
        this.setLocation(locationBefore);
    }

    public boolean rejectIfFalse(boolean condition, String key, String ... param) {
        Validate.notNull((Object)key, (String)"key is required");
        if (condition) {
            this.setValidationCheckForCurrentLocation(ValidationStatus.PASSED, key, param);
        } else {
            this.setValidationCheckForCurrentLocation(ValidationStatus.ERROR, key, param);
        }
        return condition;
    }

    public boolean rejectIfTrue(boolean condition, String key, String ... param) {
        return this.rejectIfFalse(!condition, key, param);
    }

    public boolean rejectIfNull(Object object, String key, String ... param) {
        return this.rejectIfTrue(object == null, key, param);
    }

    public boolean rejectIfNotNull(Object object, String key, String ... param) {
        return this.rejectIfTrue(object != null, key, param);
    }

    public void addMetric(String name, String value) {
        if (!this.metrics.containsKey(this.currentLocation)) {
            this.metrics.put(this.currentLocation, new ArrayList());
        }
        this.metrics.get(this.currentLocation).add(new ValidationMetric(name, value, DateTimeUtils.currentTimeMillis()));
    }

    public Set<ValidationLocation> getValidatedLocations() {
        return this.results.keySet();
    }

    public ValidationLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean hasFailures() {
        return !this.getFailuresForAllLocations().isEmpty();
    }

    public boolean hasWarnings() {
        return !this.getWarnings().isEmpty();
    }

    public boolean hasNoFailuresOrWarnings() {
        return !this.hasFailures() && !this.hasWarnings();
    }

    public Set<ValidationCheck> getFailuresForCurrentLocation() {
        return new HashSet<ValidationCheck>(this.getFailures(this.currentLocation));
    }

    public List<ValidationCheck> getFailuresForAllLocations() {
        ArrayList<ValidationCheck> failures = new ArrayList<ValidationCheck>();
        for (ValidationLocation location : this.getValidatedLocations()) {
            failures.addAll(this.getChecks(location, ValidationStatus.ERROR));
        }
        return failures;
    }

    public List<ValidationCheck> getFailures(ValidationLocation location) {
        return this.getChecks(location, ValidationStatus.ERROR);
    }

    public boolean hasFailureForCurrentLocation() {
        return this.hasFailureForLocation(this.currentLocation);
    }

    public boolean hasFailureForLocation(ValidationLocation location) {
        return !this.getFailures(location).isEmpty();
    }

    public List<ValidationCheck> getWarnings() {
        ArrayList<ValidationCheck> warnings = new ArrayList<ValidationCheck>();
        for (ValidationLocation location : this.getValidatedLocations()) {
            warnings.addAll(this.getChecks(location, ValidationStatus.WARNING));
        }
        return warnings;
    }

    private List<ValidationCheck> getChecks(ValidationLocation location, ValidationStatus status) {
        if (this.results.containsKey(location)) {
            return this.results.get(location).get((Object)status);
        }
        return new ArrayList<ValidationCheck>();
    }

    public List<ValidationCheck> getAllValidationChecksForCurrentLocation() {
        return this.getAllValidationChecksForLocation(this.currentLocation);
    }

    public List<ValidationCheck> getAllValidationChecksForLocation(ValidationLocation location) {
        ArrayList<ValidationCheck> allChecks = new ArrayList<ValidationCheck>();
        if (this.results.containsKey(location)) {
            Map<ValidationStatus, List<ValidationCheck>> locationChecksMap = this.results.get(location);
            allChecks.addAll((Collection<ValidationCheck>)locationChecksMap.get((Object)ValidationStatus.ERROR));
            allChecks.addAll((Collection<ValidationCheck>)locationChecksMap.get((Object)ValidationStatus.WARNING));
            allChecks.addAll((Collection<ValidationCheck>)locationChecksMap.get((Object)ValidationStatus.PASSED));
        }
        return allChecks;
    }

    public ValidationCheck getResultForCurrentLocation(String checkKey) {
        return this.getResult(this.currentLocation, checkKey);
    }

    public ValidationCheck getResult(ValidationLocation location, String checkKey) {
        List<ValidationCheck> allChecks = this.getAllValidationChecksForLocation(location);
        for (ValidationCheck check : allChecks) {
            if (!check.getKey().equals(checkKey)) continue;
            return check;
        }
        return null;
    }

    public List<ValidationMetric> getMetrics(ValidationLocation location) {
        if (this.metrics.containsKey(location)) {
            return Collections.unmodifiableList(this.metrics.get(location));
        }
        return Collections.emptyList();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void addAll(ValidationResult that) {
        for (Map.Entry<ValidationLocation, Map<ValidationStatus, List<ValidationCheck>>> resultsByLocation : that.results.entrySet()) {
            Map<ValidationStatus, List<ValidationCheck>> map = this.results.get(resultsByLocation.getKey());
            if (map == null) {
                map = new LinkedHashMap<ValidationStatus, List<ValidationCheck>>();
                this.results.put(resultsByLocation.getKey(), map);
            }
            for (Map.Entry<ValidationStatus, List<ValidationCheck>> checks : resultsByLocation.getValue().entrySet()) {
                List<ValidationCheck> list = map.get((Object)checks.getKey());
                if (list == null) {
                    list = new ArrayList<ValidationCheck>();
                    map.put(checks.getKey(), list);
                }
                list.addAll((Collection<ValidationCheck>)checks.getValue());
            }
        }
    }
}

