/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ripe.rpki.commons.rsync.Command;
import org.joda.time.DateTimeUtils;

public class Rsync {
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 300;
    private static final String COMMAND = "rsync";
    private Command command;
    private String source;
    private String destination;
    private List<String> options = new ArrayList<String>();
    private int timeoutInSeconds = 300;
    private long startedAt;
    private long finishedAt;

    public Rsync() {
    }

    public Rsync(String source, String destination) {
        this.source = source;
        this.destination = destination;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        if (timeoutInSeconds < 0) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public void addOptions(String ... options) {
        for (String option : options) {
            if (option == null) continue;
            this.options.add(option);
        }
    }

    public void addOptions(Collection<String> options) {
        for (String option : options) {
            if (option == null) continue;
            this.options.add(option);
        }
    }

    public boolean containsOption(String option) {
        return this.options.contains(option);
    }

    public void reset() {
        this.command = null;
        this.options.clear();
        this.source = null;
        this.destination = null;
        this.startedAt = 0L;
        this.finishedAt = 0L;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String[] getErrorLines() {
        return this.command == null ? null : this.command.getErrorLines();
    }

    public String[] getOutputLines() {
        return this.command == null ? null : this.command.getOutputLines();
    }

    public boolean isCompleted() {
        return this.command != null && this.command.isCompleted();
    }

    public int getExitStatus() {
        return this.command == null ? -1 : this.command.getExitStatus();
    }

    public Exception getException() {
        return this.command == null ? null : this.command.getException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(COMMAND);
        args.add("--timeout=" + this.timeoutInSeconds);
        args.addAll(this.options);
        if (this.source != null && this.destination != null) {
            args.add(this.source);
            args.add(this.destination);
        }
        Command rsync = new Command(args);
        this.startedAt = DateTimeUtils.currentTimeMillis();
        try {
            rsync.execute();
            this.command = rsync;
            int exitStatus = rsync.getExitStatus();
            if (exitStatus != 0) {
                System.err.println("rsync command line: " + args);
                System.err.println("rsync exit status: " + exitStatus);
                System.err.println("rsync stderr: " + rsync.getErrors());
                System.err.println("rsync stdout: " + rsync.getOutputs());
            }
            int n = exitStatus;
            return n;
        }
        finally {
            this.finishedAt = DateTimeUtils.currentTimeMillis();
        }
    }

    public long elapsedTime() {
        return this.finishedAt - this.startedAt;
    }
}

