/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapperException;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParserException;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.PayloadParser;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningCmsCertificateParser;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class ProvisioningCmsObjectParser {
    private static final BcDigestCalculatorProvider DIGEST_CALCULATOR_PROVIDER = new BcDigestCalculatorProvider();
    private static final ASN1ObjectIdentifier PROVISIONING_OBJECT_OID_STRING = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.28");
    private static final int CMS_OBJECT_SIGNER_VERSION = 3;
    private static final int CMS_OBJECT_VERSION = 3;
    private byte[] encoded;
    private X509Certificate cmsCertificate;
    private Collection<X509Certificate> caCertificates = new HashSet<X509Certificate>();
    private X509CRL crl;
    private CMSSignedDataParser sp;
    private ValidationResult validationResult;
    private String location;
    private AbstractProvisioningPayload payload;

    public ProvisioningCmsObjectParser() {
        this(ValidationResult.withLocation("n/a"));
    }

    public ProvisioningCmsObjectParser(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void parseCms(String location, byte[] encoded) {
        this.location = location;
        this.encoded = encoded;
        this.validationResult.setLocation(new ValidationLocation(location));
        try {
            this.sp = new CMSSignedDataParser((DigestCalculatorProvider)DIGEST_CALCULATOR_PROVIDER, encoded);
        }
        catch (CMSException e) {
            this.validationResult.rejectIfFalse(false, "cms.signed.data.parsing", new String[0]);
            return;
        }
        this.validationResult.rejectIfFalse(true, "cms.signed.data.parsing", new String[0]);
        this.verifyVersionNumber();
        this.verifyDigestAlgorithm(encoded);
        this.verifyContentType();
        this.parseContent();
        this.parseCertificates();
        this.parseCmsCrl();
        this.verifySignerInfos();
    }

    public ProvisioningCmsObject getProvisioningCmsObject() {
        if (this.validationResult.hasFailures()) {
            throw new ProvisioningCmsObjectParserException("provisioning cms object validation failed: " + this.validationResult.getFailuresForCurrentLocation());
        }
        return new ProvisioningCmsObject(this.encoded, this.cmsCertificate, this.caCertificates, this.crl, this.payload);
    }

    private void verifyVersionNumber() {
        this.validationResult.rejectIfFalse(this.sp.getVersion() == 3, "cms.signed.data.version", new String[0]);
    }

    private void verifyDigestAlgorithm(byte[] data) {
        this.validationResult.rejectIfFalse(CMSSignedGenerator.DIGEST_SHA256.equals(this.getDigestAlgorithmOidFromEncodedCmsObject(data).getAlgorithm().getId()), "cms.signed.data.digest.algorithm", new String[0]);
    }

    private AlgorithmIdentifier getDigestAlgorithmOidFromEncodedCmsObject(byte[] data) {
        ContentInfo info;
        ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
        try {
            info = ContentInfo.getInstance((Object)in.readObject());
        }
        catch (IOException e) {
            throw new ProvisioningCmsObjectParserException("error while reading cms object content info", e);
        }
        SignedData signedData = SignedData.getInstance((Object)info.getContent());
        ASN1Set digestAlgorithms = signedData.getDigestAlgorithms();
        ASN1Encodable object = digestAlgorithms.getObjectAt(0);
        return AlgorithmIdentifier.getInstance((Object)object.toASN1Primitive());
    }

    private void verifyContentType() {
        this.validationResult.rejectIfFalse(PROVISIONING_OBJECT_OID_STRING.equals((Object)this.sp.getSignedContent().getContentType()), "cms.content.type", new String[0]);
    }

    private void parseContent() {
        try {
            InputSupplier<InputStream> supplier = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return ProvisioningCmsObjectParser.this.sp.getSignedContent().getContentStream();
                }
            };
            String payloadXml = CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)supplier, (Charset)Charsets.UTF_8));
            this.payload = PayloadParser.parse(payloadXml, this.validationResult);
            this.validationResult.rejectIfFalse(true, "cms.content.parsing", new String[0]);
        }
        catch (IOException e) {
            this.validationResult.rejectIfFalse(false, "cms.content.parsing", new String[0]);
        }
    }

    private void parseCertificates() {
        Collection<? extends Certificate> certificates = this.extractCertificates(this.sp);
        if (!this.validationResult.rejectIfNull(certificates, "cms.get.certs.and.crls", new String[0])) {
            return;
        }
        for (Certificate certificate : certificates) {
            if (!this.validationResult.rejectIfFalse(certificate instanceof X509Certificate, "cms.cert.is.x509", new String[0])) continue;
            this.processX509Certificate((X509Certificate)certificate);
        }
    }

    private void processX509Certificate(X509Certificate certificate) {
        if (this.isEndEntityCertificate(certificate)) {
            if (this.cmsCertificate == null) {
                this.cmsCertificate = this.parseCmsCertificate(certificate);
                this.validationResult.rejectIfFalse(true, "cms.cert.is.ee.cert", new String[0]);
                this.validationResult.rejectIfNull(X509CertificateUtil.getSubjectKeyIdentifier(this.cmsCertificate) != null, "cms.cert.has.ski", new String[0]);
            } else {
                this.validationResult.rejectIfFalse(false, "cms.only.one.ee.cert", new String[0]);
            }
        } else {
            this.caCertificates.add(certificate);
        }
    }

    private X509Certificate parseCmsCertificate(X509Certificate certificate) {
        ProvisioningCmsCertificateParser parser = new ProvisioningCmsCertificateParser();
        try {
            parser.parse(ValidationResult.withLocation(this.location), certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
        return parser.getCertificate().getCertificate();
    }

    private boolean isEndEntityCertificate(X509Certificate certificate) {
        try {
            byte[] basicConstraintsExtension = certificate.getExtensionValue(X509Extension.basicConstraints.getId());
            if (basicConstraintsExtension == null) {
                return true;
            }
            BasicConstraints constraints = BasicConstraints.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])basicConstraintsExtension));
            return !constraints.isCA();
        }
        catch (IOException e) {
            throw new ProvisioningCmsObjectParserException("error while reading cms object certificate", e);
        }
    }

    private Collection<? extends Certificate> extractCertificates(CMSSignedDataParser sp) {
        try {
            return BouncyCastleUtil.extractCertificates(sp);
        }
        catch (CMSException e) {
            return null;
        }
        catch (StoreException e) {
            return null;
        }
        catch (CertificateException e) {
            return null;
        }
    }

    private void parseCmsCrl() {
        List<? extends X509CRL> crls = this.extractCrl(this.sp);
        if (!this.validationResult.rejectIfNull(crls, "cms.get.certs.and.crls", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(crls.size() == 1, "cms.only.one.crl", new String[0])) {
            return;
        }
        CRL x509Crl = crls.get(0);
        if (this.validationResult.rejectIfFalse(x509Crl instanceof X509CRL, "cms.crl.is.x509", new String[0])) {
            this.crl = (X509CRL)x509Crl;
        }
    }

    private List<? extends X509CRL> extractCrl(CMSSignedDataParser sp) {
        try {
            return BouncyCastleUtil.extractCrls(sp);
        }
        catch (CMSException e) {
            return null;
        }
        catch (StoreException e) {
            return null;
        }
        catch (CRLException e) {
            return null;
        }
    }

    private void verifySignerInfos() {
        SignerInformationStore signerStore = this.getSignerStore();
        if (!this.validationResult.rejectIfNull(signerStore, "cms.signature.signer.info", new String[0])) {
            return;
        }
        Collection signers = signerStore.getSigners();
        this.validationResult.rejectIfFalse(signers.size() == 1, "cms.signature.has.one.signer", new String[0]);
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        this.verifySignerVersion(signer);
        this.verifySubjectKeyIdentifier(signer);
        this.verifyDigestAlgorithm(signer);
        this.verifySignedAttributes(signer);
        this.verifyEncryptionAlgorithm(signer);
        this.verifySignature(signer);
        this.verifyUnsignedAttributes(signer);
    }

    private SignerInformationStore getSignerStore() {
        SignerInformationStore signerStore;
        try {
            signerStore = this.sp.getSignerInfos();
        }
        catch (CMSException e) {
            signerStore = null;
        }
        return signerStore;
    }

    private void verifySignerVersion(SignerInformation signer) {
        this.validationResult.rejectIfFalse(signer.getVersion() == 3, "cms.signer.info.version", new String[0]);
    }

    private void verifySubjectKeyIdentifier(SignerInformation signer) {
        SignerId sid = signer.getSID();
        this.validationResult.rejectIfFalse(Arrays.equals(X509CertificateUtil.getSubjectKeyIdentifier(this.cmsCertificate), sid.getSubjectKeyIdentifier()), "cms.signer.info.ski", new String[0]);
        this.validationResult.rejectIfFalse(sid.getIssuer() == null && sid.getSerialNumber() == null, "cms.signer.info.ski.only", new String[0]);
    }

    private void verifyDigestAlgorithm(SignerInformation signer) {
        this.validationResult.rejectIfFalse(CMSSignedGenerator.DIGEST_SHA256.equals(signer.getDigestAlgOID()), "cms.signer.info.digest.algorithm", new String[0]);
    }

    private void verifySignedAttributes(SignerInformation signer) {
        AttributeTable attributeTable = signer.getSignedAttributes();
        if (!this.validationResult.rejectIfNull(attributeTable, "cms.signed.attrs.present", new String[0])) {
            return;
        }
        this.verifyContentType(attributeTable);
        this.verifyMessageDigest(attributeTable);
        this.verifySigningTime(attributeTable);
    }

    private void verifyContentType(AttributeTable attributeTable) {
        Attribute contentType = attributeTable.get(CMSAttributes.contentType);
        if (!this.validationResult.rejectIfNull(contentType, "cms.content.type.attr.present", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(contentType.getAttrValues().size() == 1, "cms.content.type.value.count", new String[0])) {
            return;
        }
        this.validationResult.rejectIfFalse(PROVISIONING_OBJECT_OID_STRING.equals((Object)contentType.getAttrValues().getObjectAt(0)), "cms.content.type.value", new String[0]);
    }

    private void verifyMessageDigest(AttributeTable attributeTable) {
        Attribute messageDigest = attributeTable.get(CMSAttributes.messageDigest);
        if (!this.validationResult.rejectIfNull(messageDigest, "cms.msg.digest.attr.present", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(messageDigest.getAttrValues().size() == 1, "cms.msg.digest.value.count", new String[0])) {
            return;
        }
    }

    private void verifySigningTime(AttributeTable attributeTable) {
        Attribute signingTime = attributeTable.get(CMSAttributes.signingTime);
        if (!this.validationResult.rejectIfNull(signingTime, "cms.signing.time.attr.present", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(signingTime.getAttrValues().size() == 1, "cms.only.one.signing.time.attr", new String[0])) {
            return;
        }
    }

    private void verifyEncryptionAlgorithm(SignerInformation signer) {
        this.validationResult.rejectIfFalse(CMSSignedGenerator.ENCRYPTION_RSA.equals(signer.getEncryptionAlgOID()), "cms.encryption.algorithm", new String[0]);
    }

    private void verifySignature(SignerInformation signer) {
        String errorMessage = null;
        try {
            this.validationResult.rejectIfFalse(signer.verify(new JcaSignerInfoVerifierBuilder(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER).build(this.cmsCertificate)), "cms.signature", new String[0]);
        }
        catch (CMSException e) {
            errorMessage = String.valueOf(e.getMessage());
        }
        catch (OperatorCreationException e) {
            errorMessage = String.valueOf(e.getMessage());
        }
        if (errorMessage != null) {
            this.validationResult.rejectIfFalse(false, "cms.signature", errorMessage);
        }
    }

    private void verifyUnsignedAttributes(SignerInformation signer) {
        this.validationResult.rejectIfFalse(signer.getUnsignedAttributes() == null, "cms.unsigned.attrs.omitted", new String[0]);
    }
}

