/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryException;

public class KeyPairFactory {
    public static final String ALGORITHM = "RSA";
    public static final int RPKI_KEY_PAIR_SIZE = 2048;
    public static final BigInteger PUBLIC_EXPONENT = RSAKeyGenParameterSpec.F4;
    private final String provider;

    public KeyPairFactory(String provider) {
        this.provider = provider;
    }

    public KeyPair generate() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM, this.provider);
            generator.initialize(new RSAKeyGenParameterSpec(2048, PUBLIC_EXPONENT));
            return generator.generateKeyPair();
        }
        catch (NoSuchProviderException e) {
            throw new KeyPairFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairFactoryException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new KeyPairFactoryException(e);
        }
    }

    public static PublicKey decodePublicKey(byte[] encoded) {
        try {
            return KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (InvalidKeySpecException e) {
            throw new KeyPairFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairFactoryException(e);
        }
    }

    public static PrivateKey decodePrivateKey(byte[] encoded) {
        try {
            return KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(encoded));
        }
        catch (InvalidKeySpecException e) {
            throw new KeyPairFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyPairFactoryException(e);
        }
    }

    public KeyPairFactory withProvider(String provider) {
        return new KeyPairFactory(provider);
    }
}

