/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import net.ripe.rpki.commons.crypto.rfc3779.ResourceExtensionEncoder;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public abstract class X509CertificateParser<T extends AbstractX509CertificateWrapper> {
    private static final String[] ALLOWED_SIGNATURE_ALGORITHM_OIDS = new String[]{PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()};
    private byte[] encoded;
    protected X509Certificate certificate;
    protected ValidationResult result;

    public void parse(String location, byte[] encoded) {
        this.parse(ValidationResult.withLocation(location), encoded);
    }

    public void parse(ValidationResult validationResult, byte[] encoded) {
        this.result = validationResult;
        this.encoded = encoded;
        this.parse();
        if (!this.result.hasFailureForCurrentLocation()) {
            this.validateSignatureAlgorithm();
            this.validatePublicKey();
            this.doTypeSpecificValidation();
        }
    }

    private void validatePublicKey() {
        PublicKey publicKey = this.certificate.getPublicKey();
        this.result.rejectIfFalse("RSA".equals(publicKey.getAlgorithm()) && publicKey instanceof RSAPublicKey, "cert.public.key.algorithm", publicKey.getAlgorithm());
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            this.result.warnIfFalse(2048 == rsaPublicKey.getModulus().bitLength(), "cert.public.key.size", String.valueOf(rsaPublicKey.getModulus().bitLength()));
        }
    }

    protected void doTypeSpecificValidation() {
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }

    public boolean isSuccess() {
        return !this.result.hasFailures();
    }

    public abstract T getCertificate();

    protected X509Certificate getX509Certificate() {
        return this.certificate;
    }

    private void parse() {
        try {
            Closer closer = Closer.create();
            try {
                InputStream input = (InputStream)closer.register((Closeable)new ByteArrayInputStream(this.encoded));
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                this.certificate = (X509Certificate)factory.generateCertificate(input);
            }
            catch (CertificateException e) {
                this.certificate = null;
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
        }
        catch (IOException e) {
            this.certificate = null;
        }
        this.result.rejectIfNull(this.certificate, "cert.parsed", new String[0]);
    }

    private void validateSignatureAlgorithm() {
        this.result.rejectIfFalse(ArrayUtils.contains((Object[])ALLOWED_SIGNATURE_ALGORITHM_OIDS, (Object)this.certificate.getSigAlgOID()), "cert.signature.algorithm", this.certificate.getSigAlgOID());
    }

    protected boolean isResourceExtensionPresent() {
        if (this.certificate.getCriticalExtensionOIDs() == null) {
            return false;
        }
        return this.certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_AUTONOMOUS_SYS_IDS.getId()) || this.certificate.getCriticalExtensionOIDs().contains(ResourceExtensionEncoder.OID_IP_ADDRESS_BLOCKS.getId());
    }
}

