/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.xml.converters;

import net.ripe.rpki.commons.xml.converters.ReadablePeriodConverter;
import org.joda.time.DateTime;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Test;

public class ReadablePeriodConverterTest {
    private ReadablePeriodConverter subject = new ReadablePeriodConverter();

    @Test
    public void shouldSupportPeriod() {
        Assert.assertTrue((boolean)this.subject.canConvert(ReadablePeriod.class));
        Assert.assertTrue((boolean)this.subject.canConvert(Period.class));
        Assert.assertTrue((boolean)this.subject.canConvert(MutablePeriod.class));
        Assert.assertFalse((boolean)this.subject.canConvert(DateTime.class));
    }

    @Test
    public void shouldConvertToString() {
        Assert.assertEquals((Object)"P3M", (Object)this.subject.toString((Object)Period.months((int)3)));
        Assert.assertEquals((Object)"P2Y3M7DT23H2M", (Object)this.subject.toString((Object)Period.years((int)2).plusMonths(3).plusDays(7).plusHours(23).plusMinutes(2)));
    }

    @Test
    public void shouldConvertFromString() {
        Assert.assertTrue((boolean)(this.subject.fromString("P3M") instanceof Period));
        Assert.assertEquals((Object)Period.months((int)3), (Object)this.subject.fromString("P3M"));
        Assert.assertEquals((Object)Period.years((int)2).plusMonths(3).plusDays(7).plusHours(23).plusMinutes(2), (Object)this.subject.fromString("P2Y3M7DT23H2M"));
    }
}

