/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class X509ResourceCertificateTest {
    public static final URI TEST_TA_URI = URI.create("rsync://host.foo/ta.cer");
    private static final ValidationLocation CERT_URI_VALIDATION_LOCATION = new ValidationLocation(TEST_TA_URI);
    public static final URI TEST_TA_CRL = URI.create("rsync://host.foo/bar/ta.crl");
    private static final URI MFT_URI = URI.create("rsync://host.foo/bar/ta.mft");
    private static final URI PUB_DIR_URI = URI.create("rsync://host.foo/bar/");
    private static final ValidationLocation CRL_DP_VALIDATION_LOCATION = new ValidationLocation(TEST_TA_CRL);
    public static final X500Principal TEST_SELF_SIGNED_CERTIFICATE_NAME = new X500Principal("CN=TEST-SELF-SIGNED-CERT");
    private static final IpResourceSet TEST_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
    private CrlLocator crlLocator;
    private static final ValidityPeriod TEST_VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)new DateTime().minusMinutes(1), (ReadableInstant)new DateTime().plusYears(100));
    private static final BigInteger TEST_SERIAL_NUMBER = BigInteger.valueOf(900L);
    private static final ValidationOptions VALIDATION_OPTIONS = new ValidationOptions();

    public static X509ResourceCertificateBuilder createSelfSignedCaCertificateBuilder() {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createBasicBuilder();
        builder.withCa(true);
        builder.withKeyUsage(6);
        return builder;
    }

    public static X509ResourceCertificateBuilder createBasicBuilder() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withIssuerDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
        builder.withSerial(TEST_SERIAL_NUMBER);
        builder.withValidityPeriod(TEST_VALIDITY_PERIOD);
        builder.withPublicKey(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
        builder.withSigningKeyPair(KeyPairFactoryTest.TEST_KEY_PAIR);
        builder.withAuthorityKeyIdentifier(true);
        X509CertificateInformationAccessDescriptor[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, PUB_DIR_URI), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, MFT_URI)};
        builder.withSubjectInformationAccess(descriptors);
        return builder;
    }

    public static X509ResourceCertificate createSelfSignedCaResourceCertificate() {
        return X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET);
    }

    public static X509ResourceCertificate createSelfSignedCaResourceCertificate(IpResourceSet ipResourceSet) {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withResources(ipResourceSet);
        return builder.build();
    }

    public static X509ResourceCertificate createSelfSignedCaResourceCertificate(KeyPair keyPair) {
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withResources(TEST_RESOURCE_SET).withSigningKeyPair(keyPair).withPublicKey(keyPair.getPublic());
        return builder.build();
    }

    public static X509ResourceCertificateBuilder createSelfSignedCaResourceCertificateBuilder() {
        return X509ResourceCertificateTest.createSelfSignedCaCertificateBuilder().withResources(TEST_RESOURCE_SET).withSubjectDN(TEST_SELF_SIGNED_CERTIFICATE_NAME).withIssuerDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
    }

    public static X509ResourceCertificateBuilder createSelfSignedEeCertificateBuilder() {
        return X509ResourceCertificateTest.createBasicBuilder().withCa(false).withResources(TEST_RESOURCE_SET).withSubjectDN(TEST_SELF_SIGNED_CERTIFICATE_NAME).withIssuerDN(TEST_SELF_SIGNED_CERTIFICATE_NAME);
    }

    @Before
    public void setUp() {
        this.crlLocator = (CrlLocator)Mockito.mock(CrlLocator.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRequireCertificate() {
        new X509ResourceCertificate(null);
    }

    @Test
    public void shouldHaveCertificate() {
        Assert.assertNotNull((Object)X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET).getCertificate());
    }

    @Test
    public void shouldDecodeResourceExtensions() {
        Assert.assertEquals((Object)TEST_RESOURCE_SET, (Object)X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET).getResources());
    }

    @Test
    public void shouldSupportResourceInheritance() {
        X509ResourceCertificate inherited = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withResources(new IpResourceSet()).withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class)).build();
        Assert.assertTrue((boolean)inherited.isResourceSetInherited());
        Assert.assertTrue((boolean)inherited.getResources().isEmpty());
        Assert.assertFalse((boolean)X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET).isResourceSetInherited());
        Assert.assertEquals((Object)"AS21212, 10.0.0.0/8, 192.168.0.0/16, ffce::/16", (Object)inherited.deriveResources(TEST_RESOURCE_SET).toString());
    }

    @Test
    public void shouldSupportInheritedAsnsOnly() {
        X509ResourceCertificate subject = X509ResourceCertificateTest.createSelfSignedCaCertificateBuilder().withResources(IpResourceSet.parse((String)"10.0.0.0/8")).withInheritedResourceTypes(EnumSet.of(IpResourceType.ASN)).build();
        Assert.assertTrue((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.ASN)));
        Assert.assertFalse((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.IPv4)));
        Assert.assertFalse((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.IPv6)));
        Assert.assertTrue((boolean)subject.isResourceSetInherited());
        Assert.assertEquals((Object)"AS21212, 10.0.0.0/8", (Object)subject.deriveResources(TEST_RESOURCE_SET).toString());
    }

    @Test
    public void shouldSupportInheritedIpAddressesOnly() {
        X509ResourceCertificate subject = X509ResourceCertificateTest.createSelfSignedCaCertificateBuilder().withResources(IpResourceSet.parse((String)"AS1234")).withInheritedResourceTypes(EnumSet.of(IpResourceType.IPv4, IpResourceType.IPv6)).build();
        Assert.assertFalse((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.ASN)));
        Assert.assertTrue((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.IPv4)));
        Assert.assertTrue((boolean)subject.isResourceTypesInherited(EnumSet.of(IpResourceType.IPv6)));
        Assert.assertTrue((boolean)subject.isResourceSetInherited());
        Assert.assertEquals((Object)"AS1234, 10.0.0.0/8, 192.168.0.0/16, ffce::/16", (Object)subject.deriveResources(TEST_RESOURCE_SET).toString());
    }

    @Test
    public void shouldSupportCaCertificate() {
        X509ResourceCertificate resourceCertificate = X509ResourceCertificateTest.createSelfSignedEeCertificateBuilder().build();
        Assert.assertTrue((boolean)resourceCertificate.isEe());
        Assert.assertFalse((boolean)resourceCertificate.isCa());
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().build();
        Assert.assertTrue((boolean)cert.isCa());
        Assert.assertFalse((boolean)cert.isEe());
    }

    @Test
    public void shouldSupportAuthorityInformationAccessExtension() throws URISyntaxException {
        Object[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, new URI("rsync://foo.host/bar/baz.cer")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS, new URI("http://foo.host/bar/baz.cer"))};
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedEeCertificateBuilder();
        builder.withAuthorityInformationAccess((X509CertificateInformationAccessDescriptor[])descriptors);
        X509ResourceCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])descriptors, (Object[])cert.getAuthorityInformationAccess());
        Assert.assertEquals((Object)descriptors[0].getLocation(), (Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS));
        Assert.assertNull((Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST));
        Assert.assertNotNull((Object)cert.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS));
    }

    @Test
    public void shouldSupportSubjectInformationAccessExtension() throws URISyntaxException {
        Object[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, new URI("rsync://foo.host/bar/")), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, new URI("http://foo.host/bar/"))};
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedEeCertificateBuilder();
        builder.withSubjectInformationAccess((X509CertificateInformationAccessDescriptor[])descriptors);
        X509ResourceCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])descriptors, (Object[])cert.getSubjectInformationAccess());
        Assert.assertNotNull((Object)cert.findFirstSubjectInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY));
    }

    @Test
    public void shouldSupportCrlDistributionPoints() {
        Object[] crlDistributionPoints = new URI[]{URI.create("rsync://localhost/ca.crl")};
        X509ResourceCertificateBuilder builder = X509ResourceCertificateTest.createSelfSignedEeCertificateBuilder();
        builder.withCrlDistributionPoints((URI[])crlDistributionPoints);
        X509ResourceCertificate cert = builder.build();
        Assert.assertArrayEquals((Object[])crlDistributionPoints, (Object[])cert.getCrlDistributionPoints());
        Assert.assertNotNull((Object)cert.findFirstRsyncCrlDistributionPoint());
    }

    @Test
    public void shouldHaveCertificatePolicy() {
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        Assert.assertEquals((Object)AbstractX509CertificateWrapper.POLICY_OID, (Object)cert.getCertificatePolicy());
    }

    @Test
    public void shouldHaveValidSignature() throws InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET);
        certificate.getCertificate().verify(KeyPairFactoryTest.TEST_KEY_PAIR.getPublic());
    }

    @Test(expected=SignatureException.class)
    public void shouldFailOnInvalidSignature() throws InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        X509ResourceCertificate certificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET);
        certificate.getCertificate().verify(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic());
    }

    @Test
    public void shouldIgnoreCrlWhenValidatingRootCertificate() {
        ValidationResult result = ValidationResult.withLocation((URI)TEST_TA_URI);
        X509ResourceCertificate selfSignedCert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(TEST_RESOURCE_SET);
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(TEST_TA_URI, selfSignedCert);
        selfSignedCert.validate(TEST_TA_URI.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
    }

    @Test
    public void shouldFailWhenCrlCannotBeLocated() {
        final ValidationResult result = ValidationResult.withLocation((URI)TEST_TA_URI);
        X509ResourceCertificate rootCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        X509ResourceCertificate subject = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withPublicKey(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic()).withSubjectDN(new X500Principal("CN=child")).withCrlDistributionPoints(new URI[]{TEST_TA_CRL}).build();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(TEST_TA_URI, rootCertificate);
        Mockito.when((Object)this.crlLocator.getCrl(TEST_TA_CRL, context, result)).thenAnswer((Answer)new Answer<X509Crl>(){

            public X509Crl answer(InvocationOnMock invocationOnMock) throws Throwable {
                Assert.assertEquals((Object)CRL_DP_VALIDATION_LOCATION, (Object)result.getCurrentLocation());
                result.rejectIfFalse(false, "cert.crl.signature", new String[0]);
                return null;
            }
        });
        result.setLocation(new ValidationLocation(TEST_TA_URI));
        subject.validate(TEST_TA_URI.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        Assert.assertEquals((Object)CERT_URI_VALIDATION_LOCATION, (Object)result.getCurrentLocation());
        Assert.assertTrue((String)"certificate should have errors", (boolean)result.hasFailureForCurrentLocation());
        Assert.assertTrue((String)"crl should have errors", (boolean)result.hasFailureForLocation(CRL_DP_VALIDATION_LOCATION));
    }

    @Test
    public void shouldValidateWhenCrlOk() {
        ValidationResult result = ValidationResult.withLocation((URI)TEST_TA_URI);
        X509ResourceCertificate rootCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        X509ResourceCertificate subject = X509ResourceCertificateTest.createSelfSignedCaResourceCertificateBuilder().withPublicKey(KeyPairFactoryTest.SECOND_TEST_KEY_PAIR.getPublic()).withSubjectDN(new X500Principal("CN=child")).withCrlDistributionPoints(new URI[]{TEST_TA_CRL}).build();
        X509Crl crl = X509CrlTest.createCrl();
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(TEST_TA_URI, rootCertificate);
        Mockito.when((Object)this.crlLocator.getCrl(TEST_TA_CRL, context, result)).thenReturn((Object)crl);
        subject.validate(TEST_TA_URI.toString(), context, this.crlLocator, VALIDATION_OPTIONS, result);
        Assert.assertEquals((Object)CERT_URI_VALIDATION_LOCATION, (Object)result.getCurrentLocation());
        Assert.assertEquals((Object)"[]", (Object)result.getFailuresForCurrentLocation().toString());
        Assert.assertFalse((boolean)result.hasFailureForLocation(CERT_URI_VALIDATION_LOCATION));
    }

    @Test
    public void shouldReturnImmutableResources() {
        X509ResourceCertificate cert = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        IpResourceSet resources = cert.getResources();
        resources.removeAll(new IpResourceSet(resources));
        Assert.assertFalse((boolean)cert.getResources().isEmpty());
    }
}

