/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.roa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.cms.roa.Roa;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.util.EqualsSupport;
import net.ripe.rpki.commons.validation.roa.AnnouncedRoute;
import org.apache.commons.lang.Validate;

public class AllowedRoute
extends EqualsSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Asn asn;
    private final IpRange prefix;
    private final int maximumLength;

    public AllowedRoute(Asn asn, IpRange prefix, int maximumLength) {
        Validate.notNull((Object)asn, (String)"asn is required");
        Validate.notNull((Object)prefix, (String)"prefix is required");
        Validate.isTrue((maximumLength >= 0 && maximumLength <= prefix.getType().getBitSize() ? 1 : 0) != 0, (String)"maximumLength out of bounds");
        this.asn = asn;
        this.prefix = prefix;
        this.maximumLength = maximumLength;
    }

    public static List<AllowedRoute> fromRoas(List<? extends Roa> roas) {
        ArrayList<AllowedRoute> result = new ArrayList<AllowedRoute>();
        for (Roa roa : roas) {
            for (RoaPrefix roaPrefix : roa.getPrefixes()) {
                result.add(new AllowedRoute(roa.getAsn(), roaPrefix.getPrefix(), roaPrefix.getEffectiveMaximumLength()));
            }
        }
        return result;
    }

    public Asn getAsn() {
        return this.asn;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public AnnouncedRoute getAnnouncedRoute() {
        return new AnnouncedRoute(this.asn, this.prefix);
    }

    public RoaPrefix getRoaPrefix() {
        Integer maxLen = this.prefix.getPrefixLength() == this.maximumLength ? null : Integer.valueOf(this.maximumLength);
        return new RoaPrefix(this.prefix, maxLen);
    }
}

