/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.revocation.response;

import java.io.IOException;
import java.security.PublicKey;
import java.util.regex.Pattern;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.payload.RelaxNgSchemaValidator;
import net.ripe.rpki.commons.provisioning.payload.revocation.CertificateRevocationKeyElement;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayload;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayloadBuilder;
import net.ripe.rpki.commons.provisioning.payload.revocation.response.CertificateRevocationResponsePayloadSerializerBuilder;
import net.ripe.rpki.commons.xml.XStreamXmlSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class CertificateRevocationResponsePayloadBuilderTest {
    private static final XStreamXmlSerializer<CertificateRevocationResponsePayload> SERIALIZER = new CertificateRevocationResponsePayloadSerializerBuilder().build();
    public static final CertificateRevocationResponsePayload TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD = CertificateRevocationResponsePayloadBuilderTest.createCertificateRevocationResponsePayload();

    public static CertificateRevocationResponsePayload createCertificateRevocationResponsePayload() {
        CertificateRevocationResponsePayloadBuilder builder = new CertificateRevocationResponsePayloadBuilder();
        builder.withClassName("a classname");
        builder.withPublicKey(ProvisioningObjectMother.X509_CA.getPublicKey());
        return builder.build();
    }

    @Test
    public void shouldBuildValidRevocationCms() throws Exception {
        Assert.assertEquals((Object)"sender", (Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getSender());
        Assert.assertEquals((Object)"recipient", (Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getRecipient());
        CertificateRevocationKeyElement payloadContent = TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD.getKeyElement();
        Assert.assertEquals((Object)"a classname", (Object)payloadContent.getClassName());
        Assert.assertEquals((Object)KeyPairUtil.getEncodedKeyIdentifier((PublicKey)ProvisioningObjectMother.X509_CA.getPublicKey()), (Object)payloadContent.getPublicKeyHash());
    }

    @Test
    public void shouldProduceXmlConformStandard() {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD);
        String expectedXmlRegex = "<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?>\n<message xmlns=\"http://www.apnic.net/specs/rescerts/up-down/\" version=\"1\" sender=\"sender\" recipient=\"recipient\" type=\"revoke_response\">\n  <key class_name=\"a classname\" ski=\"[^\"]*\"/>\n</message>";
        Assert.assertTrue((boolean)Pattern.matches(expectedXmlRegex, actualXml));
    }

    @Test
    public void shouldProduceSchemaValidatedXml() throws SAXException, IOException {
        String actualXml = SERIALIZER.serialize((Object)TEST_CERTIFICATE_REVOCATION_RESPONSE_PAYLOAD);
        Assert.assertTrue((boolean)RelaxNgSchemaValidator.validateAgainstRelaxNg(actualXml));
    }
}

