/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.cms;

import net.ripe.rpki.commons.provisioning.ProvisioningObjectMother;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObject;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParser;
import net.ripe.rpki.commons.provisioning.cms.ProvisioningCmsObjectParserException;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProvisioningCmsObjectParserTest {
    private ProvisioningCmsObjectParser subject;

    @Before
    public void setUp() {
        this.subject = new ProvisioningCmsObjectParser();
    }

    @Test
    public void shouldParseValidObject() {
        ProvisioningCmsObject cmsObject = ProvisioningObjectMother.createResourceClassListQueryProvisioningCmsObject();
        this.subject.parseCms("test-location", cmsObject.getEncoded());
        ValidationResult validationResult = this.subject.getValidationResult();
        Assert.assertFalse((boolean)validationResult.hasFailures());
        Assert.assertEquals((Object)cmsObject, (Object)this.subject.getProvisioningCmsObject());
    }

    @Test(expected=ProvisioningCmsObjectParserException.class)
    public void shouldFailOnInvalidObject() {
        this.subject.parseCms("test-location", new byte[]{0});
        ValidationResult validationResult = this.subject.getValidationResult();
        Assert.assertTrue((boolean)validationResult.hasFailures());
        Assert.assertEquals((long)1L, (long)validationResult.getFailuresForCurrentLocation().size());
        Assert.assertEquals((Object)"cms.signed.data.parsing", (Object)((ValidationCheck)validationResult.getFailuresForCurrentLocation().iterator().next()).getKey());
        this.subject.getProvisioningCmsObject();
    }
}

