/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.interop;

import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class BBNRoaConformanceTest {
    private static final String PATH_TO_BBN_OBJECTS = "src/test/resources/conformance/";

    @Test
    public void shouldParseRoaWithMissingSignature() throws IOException {
        boolean hasFailure = this.parseRoa("root/badCMSSigInfoNoSig.roa");
        Assert.assertTrue((boolean)hasFailure);
    }

    @Test
    public void shouldParseRoaWithNoSignerInfo() throws IOException {
        boolean hasFailure = this.parseRoa("root/badCMSNoSigInfo.roa");
        Assert.assertTrue((boolean)hasFailure);
    }

    private boolean parseRoa(String roa) throws IOException {
        File file = new File(PATH_TO_BBN_OBJECTS, roa);
        byte[] encoded = FileUtils.readFileToByteArray((File)file);
        ValidationResult result = ValidationResult.withLocation((String)file.getName());
        new RoaCmsParser().parse(result, encoded);
        return result.hasFailures();
    }
}

